/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectparticipant.ConnectParticipantAsyncClient;
import software.amazon.awssdk.services.connectparticipant.model.GetTranscriptRequest;
import software.amazon.awssdk.services.connectparticipant.model.GetTranscriptResponse;

public class GetTranscriptPublisher
implements SdkPublisher<GetTranscriptResponse> {
    private final ConnectParticipantAsyncClient client;
    private final GetTranscriptRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTranscriptPublisher(ConnectParticipantAsyncClient client, GetTranscriptRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTranscriptPublisher(ConnectParticipantAsyncClient client, GetTranscriptRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTranscriptResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTranscriptResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetTranscriptResponseFetcher
    implements AsyncPageFetcher<GetTranscriptResponse> {
        private GetTranscriptResponseFetcher() {
        }

        public boolean hasNextPage(GetTranscriptResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTranscriptResponse> nextPage(GetTranscriptResponse previousPage) {
            if (previousPage == null) {
                return GetTranscriptPublisher.this.client.getTranscript(GetTranscriptPublisher.this.firstRequest);
            }
            return GetTranscriptPublisher.this.client.getTranscript((GetTranscriptRequest)((Object)GetTranscriptPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

