/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Quantifies the anomaly. The higher score means that it's more anomalous.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyScore implements SdkPojo, Serializable, ToCopyableBuilder<AnomalyScore.Builder, AnomalyScore> {
    private static final SdkField<Double> MAX_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxScore").getter(getter(AnomalyScore::maxScore)).setter(setter(Builder::maxScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxScore").build()).build();

    private static final SdkField<Double> CURRENT_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("CurrentScore").getter(getter(AnomalyScore::currentScore)).setter(setter(Builder::currentScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_SCORE_FIELD,
            CURRENT_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double maxScore;

    private final Double currentScore;

    private AnomalyScore(BuilderImpl builder) {
        this.maxScore = builder.maxScore;
        this.currentScore = builder.currentScore;
    }

    /**
     * <p>
     * The maximum score that's observed during the <code>AnomalyDateInterval</code>.
     * </p>
     * 
     * @return The maximum score that's observed during the <code>AnomalyDateInterval</code>.
     */
    public final Double maxScore() {
        return maxScore;
    }

    /**
     * <p>
     * The last observed score.
     * </p>
     * 
     * @return The last observed score.
     */
    public final Double currentScore() {
        return currentScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxScore());
        hashCode = 31 * hashCode + Objects.hashCode(currentScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyScore)) {
            return false;
        }
        AnomalyScore other = (AnomalyScore) obj;
        return Objects.equals(maxScore(), other.maxScore()) && Objects.equals(currentScore(), other.currentScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyScore").add("MaxScore", maxScore()).add("CurrentScore", currentScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxScore":
            return Optional.ofNullable(clazz.cast(maxScore()));
        case "CurrentScore":
            return Optional.ofNullable(clazz.cast(currentScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyScore, T> g) {
        return obj -> g.apply((AnomalyScore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyScore> {
        /**
         * <p>
         * The maximum score that's observed during the <code>AnomalyDateInterval</code>.
         * </p>
         * 
         * @param maxScore
         *        The maximum score that's observed during the <code>AnomalyDateInterval</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxScore(Double maxScore);

        /**
         * <p>
         * The last observed score.
         * </p>
         * 
         * @param currentScore
         *        The last observed score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentScore(Double currentScore);
    }

    static final class BuilderImpl implements Builder {
        private Double maxScore;

        private Double currentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyScore model) {
            maxScore(model.maxScore);
            currentScore(model.currentScore);
        }

        public final Double getMaxScore() {
            return maxScore;
        }

        public final void setMaxScore(Double maxScore) {
            this.maxScore = maxScore;
        }

        @Override
        public final Builder maxScore(Double maxScore) {
            this.maxScore = maxScore;
            return this;
        }

        public final Double getCurrentScore() {
            return currentScore;
        }

        public final void setCurrentScore(Double currentScore) {
            this.currentScore = currentScore;
        }

        @Override
        public final Builder currentScore(Double currentScore) {
            this.currentScore = currentScore;
            return this;
        }

        @Override
        public AnomalyScore build() {
            return new AnomalyScore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
