/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt;

import software.amazon.awssdk.crt.mqtt.QualityOfService;

public final class MqttMessage {
    private String topic;
    private final byte[] payload;
    private QualityOfService qos;
    private boolean retain;
    private boolean dup;

    public MqttMessage(String topic, byte[] payload, QualityOfService qos, boolean retain, boolean dup) {
        this.topic = topic;
        this.payload = payload;
        this.dup = dup;
        this.qos = qos;
        this.retain = retain;
    }

    public MqttMessage(String topic, byte[] payload, QualityOfService qos, boolean retain) {
        this(topic, payload, qos, retain, false);
    }

    public MqttMessage(String topic, byte[] payload, QualityOfService qos) {
        this(topic, payload, qos, false, false);
    }

    @Deprecated
    public MqttMessage(String topic, byte[] payload) {
        this(topic, payload, QualityOfService.AT_LEAST_ONCE, false, false);
    }

    public String getTopic() {
        return this.topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public QualityOfService getQos() {
        return this.qos;
    }

    public boolean getRetain() {
        return this.retain;
    }

    public boolean getDup() {
        return this.dup;
    }
}

