/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.auth.credentials.CognitoLoginTokenSource;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.TlsContext;

public class CognitoCredentialsProvider
extends CredentialsProvider {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final int BUFFER_INT_SIZE = 4;

    private CognitoCredentialsProvider(CognitoCredentialsProviderBuilder builder) {
        String endpoint = builder.getEndpoint();
        String identity = builder.getIdentity();
        if (endpoint == null || identity == null) {
            throw new IllegalArgumentException("CognitoCredentialsProvider - endpoint and identity must not be null");
        }
        ClientBootstrap clientBootstrap = builder.getClientBootstrap();
        if (clientBootstrap == null) {
            clientBootstrap = ClientBootstrap.getOrCreateStaticDefault();
        }
        TlsContext tlsContext = builder.getTlsContext();
        if (clientBootstrap == null || tlsContext == null) {
            throw new IllegalArgumentException("CognitoCredentialsProvider - clientBootstrap and tlsContext must not be null");
        }
        int proxyConnectionType = 0;
        long proxyTlsContextHandle = 0L;
        String proxyHost = null;
        int proxyPort = 0;
        int proxyAuthorizationType = 0;
        String proxyAuthorizationUsername = null;
        String proxyAuthorizationPassword = null;
        HttpProxyOptions proxyOptions = builder.getHttpProxyOptions();
        if (proxyOptions != null) {
            proxyConnectionType = proxyOptions.getConnectionType().getValue();
            TlsContext proxyTlsContext = proxyOptions.getTlsContext();
            if (proxyTlsContext != null) {
                proxyTlsContextHandle = proxyTlsContext.getNativeHandle();
            }
            proxyHost = proxyOptions.getHost();
            proxyPort = proxyOptions.getPort();
            proxyAuthorizationType = proxyOptions.getAuthorizationType().getValue();
            proxyAuthorizationUsername = proxyOptions.getAuthorizationUsername();
            proxyAuthorizationPassword = proxyOptions.getAuthorizationPassword();
        }
        long nativeHandle = CognitoCredentialsProvider.cognitoCredentialsProviderNew(this, clientBootstrap.getNativeHandle(), tlsContext.getNativeHandle(), endpoint, identity, builder.getCustomRoleArn(), CognitoCredentialsProvider.marshalLoginsForJni(builder.getLogins()), proxyConnectionType, proxyHost != null ? proxyHost.getBytes(UTF8) : null, proxyPort, proxyTlsContextHandle, proxyAuthorizationType, proxyAuthorizationUsername != null ? proxyAuthorizationUsername.getBytes(UTF8) : null, proxyAuthorizationPassword != null ? proxyAuthorizationPassword.getBytes(UTF8) : null, builder.loginTokenSource);
        this.acquireNativeHandle(nativeHandle);
        this.addReferenceTo(clientBootstrap);
        this.addReferenceTo(tlsContext);
    }

    private static void writeLengthPrefixedBytesSafe(ByteBuffer buffer, byte[] bytes) {
        if (bytes != null) {
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        } else {
            buffer.putInt(0);
        }
    }

    private static byte[] marshalLoginsForJni(List<CognitoLoginTokenPair> logins) {
        int size = 0;
        for (CognitoLoginTokenPair login : logins) {
            size += 8;
            if (login.identityProviderName != null) {
                size += login.identityProviderName.length;
            }
            if (login.identityProviderToken == null) continue;
            size += login.identityProviderToken.length;
        }
        if (size == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (CognitoLoginTokenPair login : logins) {
            CognitoCredentialsProvider.writeLengthPrefixedBytesSafe(buffer, login.identityProviderName);
            CognitoCredentialsProvider.writeLengthPrefixedBytesSafe(buffer, login.identityProviderToken);
        }
        return buffer.array();
    }

    private static CompletableFuture<List<CognitoLoginTokenPair>> createChainedFuture(long invocationHandle, CompletableFuture<List<CognitoLoginTokenPair>> baseFuture) {
        return baseFuture.whenComplete((token_pairs, ex) -> {
            if (ex == null) {
                CognitoCredentialsProvider.completeLoginTokenFetch(invocationHandle, CognitoCredentialsProvider.marshalLoginsForJni(token_pairs), null);
            } else {
                CognitoCredentialsProvider.completeLoginTokenFetch(invocationHandle, null, ex);
            }
        });
    }

    private static native long cognitoCredentialsProviderNew(CognitoCredentialsProvider var0, long var1, long var3, String var5, String var6, String var7, byte[] var8, int var9, byte[] var10, int var11, long var12, int var14, byte[] var15, byte[] var16, CognitoLoginTokenSource var17);

    private static native void completeLoginTokenFetch(long var0, byte[] var2, Throwable var3);

    public static class CognitoCredentialsProviderBuilder {
        private String endpoint;
        private String identity;
        private String customRoleArn;
        private ArrayList<CognitoLoginTokenPair> logins = new ArrayList();
        private CognitoLoginTokenSource loginTokenSource;
        private TlsContext tlsContext;
        private ClientBootstrap clientBootstrap;
        private HttpProxyOptions httpProxyOptions;

        public CognitoCredentialsProviderBuilder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public CognitoCredentialsProviderBuilder withIdentity(String identity) {
            this.identity = identity;
            return this;
        }

        public String getIdentity() {
            return this.identity;
        }

        public CognitoCredentialsProviderBuilder withCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public String getCustomRoleArn() {
            return this.customRoleArn;
        }

        public CognitoCredentialsProviderBuilder withLogin(CognitoLoginTokenPair login) {
            this.logins.add(login);
            return this;
        }

        public ArrayList<CognitoLoginTokenPair> getLogins() {
            return this.logins;
        }

        public CognitoCredentialsProviderBuilder withClientBootstrap(ClientBootstrap clientBootstrap) {
            this.clientBootstrap = clientBootstrap;
            return this;
        }

        ClientBootstrap getClientBootstrap() {
            return this.clientBootstrap;
        }

        public CognitoCredentialsProviderBuilder withTlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        TlsContext getTlsContext() {
            return this.tlsContext;
        }

        public CognitoCredentialsProviderBuilder withHttpProxyOptions(HttpProxyOptions httpProxyOptions) {
            this.httpProxyOptions = httpProxyOptions;
            return this;
        }

        HttpProxyOptions getHttpProxyOptions() {
            return this.httpProxyOptions;
        }

        public CognitoCredentialsProviderBuilder withLoginTokenSource(CognitoLoginTokenSource loginTokenSource) {
            this.loginTokenSource = loginTokenSource;
            return this;
        }

        CognitoLoginTokenSource getLoginTokenSource() {
            return this.loginTokenSource;
        }

        public CognitoCredentialsProvider build() {
            return new CognitoCredentialsProvider(this);
        }
    }

    public static class CognitoLoginTokenPair {
        public final byte[] identityProviderName;
        public final byte[] identityProviderToken;

        public CognitoLoginTokenPair(String identityProviderName, String identityProviderToken) {
            this.identityProviderName = identityProviderName.getBytes(UTF8);
            this.identityProviderToken = identityProviderToken.getBytes(UTF8);
        }
    }
}

