/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.mqtt5.QOS;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class PublishPacket {
    private byte[] payload;
    private QOS packetQOS;
    private Boolean retain;
    private String topic;
    private PayloadFormatIndicator payloadFormat;
    private Long messageExpiryIntervalSeconds;
    private Long topicAlias;
    private String responseTopic;
    private byte[] correlationData;
    private List<Long> subscriptionIdentifiers;
    private String contentType;
    private List<UserProperty> userProperties;

    public byte[] getPayload() {
        return this.payload;
    }

    public QOS getQOS() {
        return this.packetQOS;
    }

    public Boolean getRetain() {
        return this.retain;
    }

    public String getTopic() {
        return this.topic;
    }

    public PayloadFormatIndicator getPayloadFormat() {
        return this.payloadFormat;
    }

    public Long getMessageExpiryIntervalSeconds() {
        return this.messageExpiryIntervalSeconds;
    }

    public Long getTopicAlias() {
        return this.topicAlias;
    }

    public String getResponseTopic() {
        return this.responseTopic;
    }

    public byte[] getCorrelationData() {
        return this.correlationData;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public List<Long> getSubscriptionIdentifiers() {
        return this.subscriptionIdentifiers;
    }

    public static PublishPacket of(String topic, QOS qos, byte[] payload) {
        Objects.requireNonNull(topic, "topic");
        Objects.requireNonNull(qos, "qos");
        Objects.requireNonNull(payload, "payload");
        return new PublishPacketBuilder(topic, qos, payload).build();
    }

    private PublishPacket(PublishPacketBuilder builder) {
        this.payload = builder.payload;
        this.packetQOS = builder.packetQOS;
        this.retain = builder.retain;
        this.topic = builder.topic;
        this.payloadFormat = builder.payloadFormat;
        this.messageExpiryIntervalSeconds = builder.messageExpiryIntervalSeconds;
        this.topicAlias = builder.topicAlias;
        this.responseTopic = builder.responseTopic;
        this.correlationData = builder.correlationData;
        this.contentType = builder.contentType;
        this.userProperties = builder.userProperties;
    }

    private PublishPacket() {
    }

    private void nativeSetQOS(int QOSValue) {
        this.packetQOS = QOS.getEnumValueFromInteger(QOSValue);
    }

    private void nativeSetPayloadFormatIndicator(int payloadFormatIndicator) {
        this.payloadFormat = PayloadFormatIndicator.getEnumValueFromInteger(payloadFormatIndicator);
    }

    public static final class PublishPacketBuilder {
        private byte[] payload;
        private QOS packetQOS;
        private Boolean retain;
        private String topic;
        private PayloadFormatIndicator payloadFormat;
        private Long messageExpiryIntervalSeconds;
        private Long topicAlias;
        private String responseTopic;
        private byte[] correlationData;
        private String contentType;
        private List<UserProperty> userProperties;

        public PublishPacketBuilder withPayload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public PublishPacketBuilder withQOS(QOS packetQOS) {
            this.packetQOS = packetQOS;
            return this;
        }

        public PublishPacketBuilder withRetain(Boolean retain) {
            this.retain = retain;
            return this;
        }

        public PublishPacketBuilder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public PublishPacketBuilder withPayloadFormat(PayloadFormatIndicator payloadFormat) {
            this.payloadFormat = payloadFormat;
            return this;
        }

        public PublishPacketBuilder withMessageExpiryIntervalSeconds(Long messageExpiryIntervalSeconds) {
            this.messageExpiryIntervalSeconds = messageExpiryIntervalSeconds;
            return this;
        }

        public PublishPacketBuilder withTopicAlias(long topicAlias) {
            this.topicAlias = topicAlias;
            return this;
        }

        public PublishPacketBuilder withResponseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
            return this;
        }

        public PublishPacketBuilder withCorrelationData(byte[] correlationData) {
            this.correlationData = correlationData;
            return this;
        }

        public PublishPacketBuilder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public PublishPacketBuilder withUserProperties(List<UserProperty> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public PublishPacketBuilder() {
        }

        public PublishPacketBuilder(String topic, QOS packetQOS, byte[] payload) {
            this.topic = topic;
            this.packetQOS = packetQOS;
            this.payload = payload;
        }

        public PublishPacket build() {
            return new PublishPacket(this);
        }
    }

    public static enum PayloadFormatIndicator {
        BYTES(0),
        UTF8(1);

        private int indicator;
        private static Map<Integer, PayloadFormatIndicator> enumMapping;

        private PayloadFormatIndicator(int value) {
            this.indicator = value;
        }

        public int getValue() {
            return this.indicator;
        }

        public static PayloadFormatIndicator getEnumValueFromInteger(int value) {
            PayloadFormatIndicator enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal PayloadFormatIndicator");
        }

        private static Map<Integer, PayloadFormatIndicator> buildEnumMapping() {
            return Stream.of(PayloadFormatIndicator.values()).collect(Collectors.toMap(PayloadFormatIndicator::getValue, Function.identity()));
        }

        static {
            enumMapping = PayloadFormatIndicator.buildEnumMapping();
        }
    }
}

