/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.Log;

public final class EventLoopGroup
extends CrtResource {
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();
    private static int staticDefaultNumThreads = Math.max(1, Runtime.getRuntime().availableProcessors());
    private static EventLoopGroup staticDefaultEventLoopGroup;

    public EventLoopGroup(int numThreads) throws CrtRuntimeException {
        this.acquireNativeHandle(EventLoopGroup.eventLoopGroupNew(numThreads));
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            EventLoopGroup.eventLoopGroupDestroy(this, this.getNativeHandle());
        }
    }

    private void onCleanupComplete() {
        Log.log(Log.LogLevel.Trace, Log.LogSubject.IoEventLoop, "EventLoopGroup.onCleanupComplete");
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStaticDefaultNumThreads(int numThreads) {
        Class<EventLoopGroup> clazz = EventLoopGroup.class;
        synchronized (EventLoopGroup.class) {
            staticDefaultNumThreads = Math.max(1, numThreads);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeStaticDefault() {
        Class<EventLoopGroup> clazz = EventLoopGroup.class;
        synchronized (EventLoopGroup.class) {
            if (staticDefaultEventLoopGroup != null) {
                staticDefaultEventLoopGroup.close();
            }
            staticDefaultEventLoopGroup = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EventLoopGroup getOrCreateStaticDefault() {
        EventLoopGroup elg = null;
        Class<EventLoopGroup> clazz = EventLoopGroup.class;
        synchronized (EventLoopGroup.class) {
            if (staticDefaultEventLoopGroup == null) {
                staticDefaultEventLoopGroup = new EventLoopGroup(staticDefaultNumThreads);
            }
            elg = staticDefaultEventLoopGroup;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return elg;
        }
    }

    private static native long eventLoopGroupNew(int var0) throws CrtRuntimeException;

    private static native void eventLoopGroupDestroy(EventLoopGroup var0, long var1);
}

