/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt;

import java.util.function.Consumer;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.mqtt.MqttClient;
import software.amazon.awssdk.crt.mqtt.MqttClientConnectionEvents;
import software.amazon.awssdk.crt.mqtt.MqttException;
import software.amazon.awssdk.crt.mqtt.MqttMessage;
import software.amazon.awssdk.crt.mqtt.QualityOfService;
import software.amazon.awssdk.crt.mqtt.WebsocketHandshakeTransformArgs;

public final class MqttConnectionConfig
extends CrtResource {
    private String endpoint;
    private int port;
    private SocketOptions socketOptions;
    private MqttClient mqttClient;
    private String clientId;
    private String username;
    private String password;
    private MqttClientConnectionEvents connectionCallbacks;
    private int keepAliveMs = 0;
    private int pingTimeoutMs = 0;
    private boolean cleanSession = true;
    private MqttMessage willMessage;
    private QualityOfService willQos;
    private boolean willRetain;
    private boolean useWebsockets = false;
    private HttpProxyOptions websocketProxyOptions;
    private Consumer<WebsocketHandshakeTransformArgs> websocketHandshakeTransform;

    @Override
    protected void releaseNativeHandle() {
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    public void setConnectionCallbacks(MqttClientConnectionEvents connectionCallbacks) {
        this.connectionCallbacks = connectionCallbacks;
    }

    public MqttClientConnectionEvents getConnectionCallbacks() {
        return this.connectionCallbacks;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setSocketOptions(SocketOptions socketOptions) {
        this.swapReferenceTo(this.socketOptions, socketOptions);
        this.socketOptions = socketOptions;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public boolean getCleanSession() {
        return this.cleanSession;
    }

    public void setKeepAliveMs(int keepAliveMs) {
        this.keepAliveMs = keepAliveMs;
    }

    public int getKeepAliveMs() {
        return this.keepAliveMs;
    }

    public void setPingTimeoutMs(int pingTimeoutMs) {
        this.pingTimeoutMs = pingTimeoutMs;
    }

    public int getPingTimeoutMs() {
        return this.pingTimeoutMs;
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.swapReferenceTo(this.mqttClient, mqttClient);
        this.mqttClient = mqttClient;
    }

    public MqttClient getMqttClient() {
        return this.mqttClient;
    }

    public void setLogin(String user, String pass) throws MqttException {
        this.username = user;
        this.password = pass;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setWillMessage(MqttMessage willMessage) {
        this.willMessage = willMessage;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public void setWillQos(QualityOfService qos) {
        this.willQos = qos;
    }

    public QualityOfService getWillQos() {
        return this.willQos;
    }

    public void setWillRetain(boolean retain) {
        this.willRetain = retain;
    }

    public boolean getWillRetain() {
        return this.willRetain;
    }

    public void setUseWebsockets(boolean useWebsockets) {
        this.useWebsockets = useWebsockets;
    }

    public boolean getUseWebsockets() {
        return this.useWebsockets;
    }

    public void setWebsocketProxyOptions(HttpProxyOptions proxyOptions) {
        this.websocketProxyOptions = proxyOptions;
    }

    public HttpProxyOptions getWebsocketProxyOptions() {
        return this.websocketProxyOptions;
    }

    public void setWebsocketHandshakeTransform(Consumer<WebsocketHandshakeTransformArgs> handshakeTransform) {
        this.websocketHandshakeTransform = handshakeTransform;
    }

    public Consumer<WebsocketHandshakeTransformArgs> getWebsocketHandshakeTransform() {
        return this.websocketHandshakeTransform;
    }

    public MqttConnectionConfig clone() {
        try (MqttConnectionConfig clone = new MqttConnectionConfig();){
            clone.setEndpoint(this.getEndpoint());
            clone.setPort(this.getPort());
            clone.setSocketOptions(this.getSocketOptions());
            clone.setMqttClient(this.getMqttClient());
            clone.setClientId(this.getClientId());
            clone.setUsername(this.getUsername());
            clone.setPassword(this.getPassword());
            clone.setConnectionCallbacks(this.getConnectionCallbacks());
            clone.setKeepAliveMs(this.getKeepAliveMs());
            clone.setPingTimeoutMs(this.getPingTimeoutMs());
            clone.setCleanSession(this.getCleanSession());
            clone.setWillMessage(this.getWillMessage());
            clone.setWillQos(this.getWillQos());
            clone.setWillRetain(this.getWillRetain());
            clone.setUseWebsockets(this.getUseWebsockets());
            clone.setWebsocketProxyOptions(this.getWebsocketProxyOptions());
            clone.setWebsocketHandshakeTransform(this.getWebsocketHandshakeTransform());
            clone.addRef();
            MqttConnectionConfig mqttConnectionConfig = clone;
            return mqttConnectionConfig;
        }
    }
}

