/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.DataBrewRequest;
import software.amazon.awssdk.services.databrew.model.EncryptionMode;
import software.amazon.awssdk.services.databrew.model.LogSubscription;
import software.amazon.awssdk.services.databrew.model.S3Location;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProfileJobRequest
extends DataBrewRequest
implements ToCopyableBuilder<Builder, CreateProfileJobRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::datasetName)).setter(CreateProfileJobRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::encryptionKeyArn)).setter(CreateProfileJobRequest.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMode").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::encryptionModeAsString)).setter(CreateProfileJobRequest.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::name)).setter(CreateProfileJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogSubscription").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::logSubscriptionAsString)).setter(CreateProfileJobRequest.setter(Builder::logSubscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::maxCapacity)).setter(CreateProfileJobRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRetries").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::maxRetries)).setter(CreateProfileJobRequest.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final SdkField<S3Location> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputLocation").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::outputLocation)).setter(CreateProfileJobRequest.setter(Builder::outputLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::roleArn)).setter(CreateProfileJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::tags)).setter(CreateProfileJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(CreateProfileJobRequest.getter(CreateProfileJobRequest::timeout)).setter(CreateProfileJobRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD, ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD, MAX_RETRIES_FIELD, OUTPUT_LOCATION_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, TIMEOUT_FIELD));
    private final String datasetName;
    private final String encryptionKeyArn;
    private final String encryptionMode;
    private final String name;
    private final String logSubscription;
    private final Integer maxCapacity;
    private final Integer maxRetries;
    private final S3Location outputLocation;
    private final String roleArn;
    private final Map<String, String> tags;
    private final Integer timeout;

    private CreateProfileJobRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputLocation = builder.outputLocation;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.timeout = builder.timeout;
    }

    public String datasetName() {
        return this.datasetName;
    }

    public String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(this.encryptionMode);
    }

    public String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public String name() {
        return this.name;
    }

    public LogSubscription logSubscription() {
        return LogSubscription.fromValue(this.logSubscription);
    }

    public String logSubscriptionAsString() {
        return this.logSubscription;
    }

    public Integer maxCapacity() {
        return this.maxCapacity;
    }

    public Integer maxRetries() {
        return this.maxRetries;
    }

    public S3Location outputLocation() {
        return this.outputLocation;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Integer timeout() {
        return this.timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileJobRequest)) {
            return false;
        }
        CreateProfileJobRequest other = (CreateProfileJobRequest)((Object)obj);
        return Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.logSubscriptionAsString(), other.logSubscriptionAsString()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.timeout(), other.timeout());
    }

    public String toString() {
        return ToString.builder((String)"CreateProfileJobRequest").add("DatasetName", (Object)this.datasetName()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("Name", (Object)this.name()).add("LogSubscription", (Object)this.logSubscriptionAsString()).add("MaxCapacity", (Object)this.maxCapacity()).add("MaxRetries", (Object)this.maxRetries()).add("OutputLocation", (Object)this.outputLocation()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Timeout", (Object)this.timeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LogSubscription": {
                return Optional.ofNullable(clazz.cast(this.logSubscriptionAsString()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileJobRequest, T> g) {
        return obj -> g.apply((CreateProfileJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewRequest.BuilderImpl
    implements Builder {
        private String datasetName;
        private String encryptionKeyArn;
        private String encryptionMode;
        private String name;
        private String logSubscription;
        private Integer maxCapacity;
        private Integer maxRetries;
        private S3Location outputLocation;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileJobRequest model) {
            super(model);
            this.datasetName(model.datasetName);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.encryptionMode(model.encryptionMode);
            this.name(model.name);
            this.logSubscription(model.logSubscription);
            this.maxCapacity(model.maxCapacity);
            this.maxRetries(model.maxRetries);
            this.outputLocation(model.outputLocation);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.timeout(model.timeout);
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogSubscription() {
            return this.logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final S3Location.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(S3Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(S3Location.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileJobRequest build() {
            return new CreateProfileJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataBrewRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfileJobRequest> {
        public Builder datasetName(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionMode var1);

        public Builder name(String var1);

        public Builder logSubscription(String var1);

        public Builder logSubscription(LogSubscription var1);

        public Builder maxCapacity(Integer var1);

        public Builder maxRetries(Integer var1);

        public Builder outputLocation(S3Location var1);

        default public Builder outputLocation(Consumer<S3Location.Builder> outputLocation) {
            return this.outputLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(outputLocation)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder timeout(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

