/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PollForTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForTaskRequest extends DataPipelineRequest implements
        ToCopyableBuilder<PollForTaskRequest.Builder, PollForTaskRequest> {
    private static final SdkField<String> WORKER_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PollForTaskRequest::workerGroup)).setter(setter(Builder::workerGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerGroup").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PollForTaskRequest::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<InstanceIdentity> INSTANCE_IDENTITY_FIELD = SdkField
            .<InstanceIdentity> builder(MarshallingType.SDK_POJO).getter(getter(PollForTaskRequest::instanceIdentity))
            .setter(setter(Builder::instanceIdentity)).constructor(InstanceIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_GROUP_FIELD,
            HOSTNAME_FIELD, INSTANCE_IDENTITY_FIELD));

    private final String workerGroup;

    private final String hostname;

    private final InstanceIdentity instanceIdentity;

    private PollForTaskRequest(BuilderImpl builder) {
        super(builder);
        this.workerGroup = builder.workerGroup;
        this.hostname = builder.hostname;
        this.instanceIdentity = builder.instanceIdentity;
    }

    /**
     * <p>
     * The type of task the task runner is configured to accept and process. The worker group is set as a field on
     * objects in the pipeline when they are created. You can only specify a single value for <code>workerGroup</code>
     * in the call to <code>PollForTask</code>. There are no wildcard values permitted in <code>workerGroup</code>; the
     * string must be an exact, case-sensitive, match.
     * </p>
     * 
     * @return The type of task the task runner is configured to accept and process. The worker group is set as a field
     *         on objects in the pipeline when they are created. You can only specify a single value for
     *         <code>workerGroup</code> in the call to <code>PollForTask</code>. There are no wildcard values permitted
     *         in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.
     */
    public String workerGroup() {
        return workerGroup;
    }

    /**
     * <p>
     * The public DNS name of the calling task runner.
     * </p>
     * 
     * @return The public DNS name of the calling task runner.
     */
    public String hostname() {
        return hostname;
    }

    /**
     * <p>
     * Identity information for the EC2 instance that is hosting the task runner. You can get this value from the
     * instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance Metadata</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that your task runner is
     * running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are applied to your
     * pipeline.
     * </p>
     * 
     * @return Identity information for the EC2 instance that is hosting the task runner. You can get this value from
     *         the instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance
     *         Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that
     *         your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges
     *         are applied to your pipeline.
     */
    public InstanceIdentity instanceIdentity() {
        return instanceIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workerGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForTaskRequest)) {
            return false;
        }
        PollForTaskRequest other = (PollForTaskRequest) obj;
        return Objects.equals(workerGroup(), other.workerGroup()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(instanceIdentity(), other.instanceIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PollForTaskRequest").add("WorkerGroup", workerGroup()).add("Hostname", hostname())
                .add("InstanceIdentity", instanceIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workerGroup":
            return Optional.ofNullable(clazz.cast(workerGroup()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "instanceIdentity":
            return Optional.ofNullable(clazz.cast(instanceIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForTaskRequest, T> g) {
        return obj -> g.apply((PollForTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PollForTaskRequest> {
        /**
         * <p>
         * The type of task the task runner is configured to accept and process. The worker group is set as a field on
         * objects in the pipeline when they are created. You can only specify a single value for
         * <code>workerGroup</code> in the call to <code>PollForTask</code>. There are no wildcard values permitted in
         * <code>workerGroup</code>; the string must be an exact, case-sensitive, match.
         * </p>
         * 
         * @param workerGroup
         *        The type of task the task runner is configured to accept and process. The worker group is set as a
         *        field on objects in the pipeline when they are created. You can only specify a single value for
         *        <code>workerGroup</code> in the call to <code>PollForTask</code>. There are no wildcard values
         *        permitted in <code>workerGroup</code>; the string must be an exact, case-sensitive, match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerGroup(String workerGroup);

        /**
         * <p>
         * The public DNS name of the calling task runner.
         * </p>
         * 
         * @param hostname
         *        The public DNS name of the calling task runner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * Identity information for the EC2 instance that is hosting the task runner. You can get this value from the
         * instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance
         * Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that your
         * task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are
         * applied to your pipeline.
         * </p>
         * 
         * @param instanceIdentity
         *        Identity information for the EC2 instance that is hosting the task runner. You can get this value from
         *        the instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance
         *        Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that
         *        your task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service
         *        charges are applied to your pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentity(InstanceIdentity instanceIdentity);

        /**
         * <p>
         * Identity information for the EC2 instance that is hosting the task runner. You can get this value from the
         * instance using <code>http://169.254.169.254/latest/meta-data/instance-id</code>. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AESDG-chapter-instancedata.html">Instance
         * Metadata</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i> Passing in this value proves that your
         * task runner is running on an EC2 instance, and ensures the proper AWS Data Pipeline service charges are
         * applied to your pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceIdentity.Builder} avoiding the need to
         * create one manually via {@link InstanceIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceIdentity(InstanceIdentity)}.
         * 
         * @param instanceIdentity
         *        a consumer that will call methods on {@link InstanceIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceIdentity(InstanceIdentity)
         */
        default Builder instanceIdentity(Consumer<InstanceIdentity.Builder> instanceIdentity) {
            return instanceIdentity(InstanceIdentity.builder().applyMutation(instanceIdentity).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String workerGroup;

        private String hostname;

        private InstanceIdentity instanceIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForTaskRequest model) {
            super(model);
            workerGroup(model.workerGroup);
            hostname(model.hostname);
            instanceIdentity(model.instanceIdentity);
        }

        public final String getWorkerGroup() {
            return workerGroup;
        }

        @Override
        public final Builder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public final void setWorkerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final InstanceIdentity.Builder getInstanceIdentity() {
            return instanceIdentity != null ? instanceIdentity.toBuilder() : null;
        }

        @Override
        public final Builder instanceIdentity(InstanceIdentity instanceIdentity) {
            this.instanceIdentity = instanceIdentity;
            return this;
        }

        public final void setInstanceIdentity(InstanceIdentity.BuilderImpl instanceIdentity) {
            this.instanceIdentity = instanceIdentity != null ? instanceIdentity.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForTaskRequest build() {
            return new PollForTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
