/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of PutPipelineDefinition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPipelineDefinitionResponse extends DataPipelineResponse implements
        ToCopyableBuilder<PutPipelineDefinitionResponse.Builder, PutPipelineDefinitionResponse> {
    private static final SdkField<List<ValidationError>> VALIDATION_ERRORS_FIELD = SdkField
            .<List<ValidationError>> builder(MarshallingType.LIST)
            .getter(getter(PutPipelineDefinitionResponse::validationErrors))
            .setter(setter(Builder::validationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ValidationWarning>> VALIDATION_WARNINGS_FIELD = SdkField
            .<List<ValidationWarning>> builder(MarshallingType.LIST)
            .getter(getter(PutPipelineDefinitionResponse::validationWarnings))
            .setter(setter(Builder::validationWarnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationWarnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationWarning> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationWarning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ERRORED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutPipelineDefinitionResponse::errored)).setter(setter(Builder::errored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errored").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ERRORS_FIELD,
            VALIDATION_WARNINGS_FIELD, ERRORED_FIELD));

    private final List<ValidationError> validationErrors;

    private final List<ValidationWarning> validationWarnings;

    private final Boolean errored;

    private PutPipelineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.validationErrors = builder.validationErrors;
        this.validationWarnings = builder.validationWarnings;
        this.errored = builder.errored;
    }

    /**
     * Returns true if the ValidationErrors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidationErrors() {
        return validationErrors != null && !(validationErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.
     */
    public List<ValidationError> validationErrors() {
        return validationErrors;
    }

    /**
     * Returns true if the ValidationWarnings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidationWarnings() {
        return validationWarnings != null && !(validationWarnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationWarnings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.
     */
    public List<ValidationWarning> validationWarnings() {
        return validationWarnings;
    }

    /**
     * <p>
     * Indicates whether there were validation errors, and the pipeline definition is stored but cannot be activated
     * until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the corrected pipeline.
     * </p>
     * 
     * @return Indicates whether there were validation errors, and the pipeline definition is stored but cannot be
     *         activated until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the
     *         corrected pipeline.
     */
    public Boolean errored() {
        return errored;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(validationErrors());
        hashCode = 31 * hashCode + Objects.hashCode(validationWarnings());
        hashCode = 31 * hashCode + Objects.hashCode(errored());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionResponse)) {
            return false;
        }
        PutPipelineDefinitionResponse other = (PutPipelineDefinitionResponse) obj;
        return Objects.equals(validationErrors(), other.validationErrors())
                && Objects.equals(validationWarnings(), other.validationWarnings()) && Objects.equals(errored(), other.errored());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPipelineDefinitionResponse").add("ValidationErrors", validationErrors())
                .add("ValidationWarnings", validationWarnings()).add("Errored", errored()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validationErrors":
            return Optional.ofNullable(clazz.cast(validationErrors()));
        case "validationWarnings":
            return Optional.ofNullable(clazz.cast(validationWarnings()));
        case "errored":
            return Optional.ofNullable(clazz.cast(errored()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPipelineDefinitionResponse, T> g) {
        return obj -> g.apply((PutPipelineDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutPipelineDefinitionResponse> {
        /**
         * <p>
         * The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.
         * </p>
         * 
         * @param validationErrors
         *        The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(Collection<ValidationError> validationErrors);

        /**
         * <p>
         * The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.
         * </p>
         * 
         * @param validationErrors
         *        The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(ValidationError... validationErrors);

        /**
         * <p>
         * The validation errors that are associated with the objects defined in <code>pipelineObjects</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationError>.Builder} avoiding the need
         * to create one manually via {@link List<ValidationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationError>.Builder#build()} is called immediately and
         * its result is passed to {@link #validationErrors(List<ValidationError>)}.
         * 
         * @param validationErrors
         *        a consumer that will call methods on {@link List<ValidationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationErrors(List<ValidationError>)
         */
        Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors);

        /**
         * <p>
         * The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.
         * </p>
         * 
         * @param validationWarnings
         *        The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationWarnings(Collection<ValidationWarning> validationWarnings);

        /**
         * <p>
         * The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.
         * </p>
         * 
         * @param validationWarnings
         *        The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationWarnings(ValidationWarning... validationWarnings);

        /**
         * <p>
         * The validation warnings that are associated with the objects defined in <code>pipelineObjects</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationWarning>.Builder} avoiding the
         * need to create one manually via {@link List<ValidationWarning>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationWarning>.Builder#build()} is called immediately
         * and its result is passed to {@link #validationWarnings(List<ValidationWarning>)}.
         * 
         * @param validationWarnings
         *        a consumer that will call methods on {@link List<ValidationWarning>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationWarnings(List<ValidationWarning>)
         */
        Builder validationWarnings(Consumer<ValidationWarning.Builder>... validationWarnings);

        /**
         * <p>
         * Indicates whether there were validation errors, and the pipeline definition is stored but cannot be activated
         * until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the corrected pipeline.
         * </p>
         * 
         * @param errored
         *        Indicates whether there were validation errors, and the pipeline definition is stored but cannot be
         *        activated until you correct the pipeline and call <code>PutPipelineDefinition</code> to commit the
         *        corrected pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errored(Boolean errored);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private List<ValidationWarning> validationWarnings = DefaultSdkAutoConstructList.getInstance();

        private Boolean errored;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPipelineDefinitionResponse model) {
            super(model);
            validationErrors(model.validationErrors);
            validationWarnings(model.validationWarnings);
            errored(model.errored);
        }

        public final Collection<ValidationError.Builder> getValidationErrors() {
            return validationErrors != null ? validationErrors.stream().map(ValidationError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError... validationErrors) {
            validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors) {
            validationErrors(Stream.of(validationErrors).map(c -> ValidationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copyFromBuilder(validationErrors);
        }

        public final Collection<ValidationWarning.Builder> getValidationWarnings() {
            return validationWarnings != null ? validationWarnings.stream().map(ValidationWarning::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationWarnings(Collection<ValidationWarning> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copy(validationWarnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(ValidationWarning... validationWarnings) {
            validationWarnings(Arrays.asList(validationWarnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(Consumer<ValidationWarning.Builder>... validationWarnings) {
            validationWarnings(Stream.of(validationWarnings).map(c -> ValidationWarning.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationWarnings(Collection<ValidationWarning.BuilderImpl> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copyFromBuilder(validationWarnings);
        }

        public final Boolean getErrored() {
            return errored;
        }

        @Override
        public final Builder errored(Boolean errored) {
            this.errored = errored;
            return this;
        }

        public final void setErrored(Boolean errored) {
            this.errored = errored;
        }

        @Override
        public PutPipelineDefinitionResponse build() {
            return new PutPipelineDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
