/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An individual DAX parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterNameValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterNameValue.Builder, ParameterNameValue> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterNameValue::parameterName)).setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterNameValue::parameterValue)).setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterValue;

    private ParameterNameValue(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The value of the parameter.
     * </p>
     * 
     * @return The value of the parameter.
     */
    public String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterNameValue)) {
            return false;
        }
        ParameterNameValue other = (ParameterNameValue) obj;
        return Objects.equals(parameterName(), other.parameterName()) && Objects.equals(parameterValue(), other.parameterValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterNameValue").add("ParameterName", parameterName())
                .add("ParameterValue", parameterValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "ParameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterNameValue, T> g) {
        return obj -> g.apply((ParameterNameValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterNameValue> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The value of the parameter.
         * </p>
         * 
         * @param parameterValue
         *        The value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterNameValue model) {
            parameterName(model.parameterName);
            parameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public ParameterNameValue build() {
            return new ParameterNameValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
