/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptDirectConnectGatewayAssociationProposalRequest extends DirectConnectRequest
        implements
        ToCopyableBuilder<AcceptDirectConnectGatewayAssociationProposalRequest.Builder, AcceptDirectConnectGatewayAssociationProposalRequest> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::directConnectGatewayId))
            .setter(setter(Builder::directConnectGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build())
            .build();

    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::proposalId)).setter(setter(Builder::proposalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalId").build()).build();

    private static final SdkField<String> ASSOCIATED_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::associatedGatewayOwnerAccount))
            .setter(setter(Builder::associatedGatewayOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGatewayOwnerAccount")
                    .build()).build();

    private static final SdkField<List<RouteFilterPrefix>> OVERRIDE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::overrideAllowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::overrideAllowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("overrideAllowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ID_FIELD, PROPOSAL_ID_FIELD, ASSOCIATED_GATEWAY_OWNER_ACCOUNT_FIELD,
            OVERRIDE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD));

    private final String directConnectGatewayId;

    private final String proposalId;

    private final String associatedGatewayOwnerAccount;

    private final List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway;

    private AcceptDirectConnectGatewayAssociationProposalRequest(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.proposalId = builder.proposalId;
        this.associatedGatewayOwnerAccount = builder.associatedGatewayOwnerAccount;
        this.overrideAllowedPrefixesToDirectConnectGateway = builder.overrideAllowedPrefixesToDirectConnectGateway;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway.
     */
    public String directConnectGatewayId() {
        return directConnectGatewayId;
    }

    /**
     * <p>
     * The ID of the request proposal.
     * </p>
     * 
     * @return The ID of the request proposal.
     */
    public String proposalId() {
        return proposalId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the virtual private gateway or transit gateway.
     * </p>
     * 
     * @return The ID of the AWS account that owns the virtual private gateway or transit gateway.
     */
    public String associatedGatewayOwnerAccount() {
        return associatedGatewayOwnerAccount;
    }

    /**
     * Returns true if the OverrideAllowedPrefixesToDirectConnectGateway property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasOverrideAllowedPrefixesToDirectConnectGateway() {
        return overrideAllowedPrefixesToDirectConnectGateway != null
                && !(overrideAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
     * </p>
     * <p>
     * For information about how to set the prefixes, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
     * >Allowed Prefixes</a> in the <i>AWS Direct Connect User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOverrideAllowedPrefixesToDirectConnectGateway()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
     *         <p>
     *         For information about how to set the prefixes, see <a href=
     *         "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
     *         >Allowed Prefixes</a> in the <i>AWS Direct Connect User Guide</i>.
     */
    public List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway() {
        return overrideAllowedPrefixesToDirectConnectGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedGatewayOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(overrideAllowedPrefixesToDirectConnectGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptDirectConnectGatewayAssociationProposalRequest)) {
            return false;
        }
        AcceptDirectConnectGatewayAssociationProposalRequest other = (AcceptDirectConnectGatewayAssociationProposalRequest) obj;
        return Objects.equals(directConnectGatewayId(), other.directConnectGatewayId())
                && Objects.equals(proposalId(), other.proposalId())
                && Objects.equals(associatedGatewayOwnerAccount(), other.associatedGatewayOwnerAccount())
                && Objects.equals(overrideAllowedPrefixesToDirectConnectGateway(),
                        other.overrideAllowedPrefixesToDirectConnectGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AcceptDirectConnectGatewayAssociationProposalRequest")
                .add("DirectConnectGatewayId", directConnectGatewayId()).add("ProposalId", proposalId())
                .add("AssociatedGatewayOwnerAccount", associatedGatewayOwnerAccount())
                .add("OverrideAllowedPrefixesToDirectConnectGateway", overrideAllowedPrefixesToDirectConnectGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayId":
            return Optional.ofNullable(clazz.cast(directConnectGatewayId()));
        case "proposalId":
            return Optional.ofNullable(clazz.cast(proposalId()));
        case "associatedGatewayOwnerAccount":
            return Optional.ofNullable(clazz.cast(associatedGatewayOwnerAccount()));
        case "overrideAllowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(overrideAllowedPrefixesToDirectConnectGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptDirectConnectGatewayAssociationProposalRequest, T> g) {
        return obj -> g.apply((AcceptDirectConnectGatewayAssociationProposalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptDirectConnectGatewayAssociationProposalRequest> {
        /**
         * <p>
         * The ID of the Direct Connect gateway.
         * </p>
         * 
         * @param directConnectGatewayId
         *        The ID of the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayId(String directConnectGatewayId);

        /**
         * <p>
         * The ID of the request proposal.
         * </p>
         * 
         * @param proposalId
         *        The ID of the request proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalId(String proposalId);

        /**
         * <p>
         * The ID of the AWS account that owns the virtual private gateway or transit gateway.
         * </p>
         * 
         * @param associatedGatewayOwnerAccount
         *        The ID of the AWS account that owns the virtual private gateway or transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedGatewayOwnerAccount(String associatedGatewayOwnerAccount);

        /**
         * <p>
         * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>AWS Direct Connect User Guide</i>.
         * </p>
         * 
         * @param overrideAllowedPrefixesToDirectConnectGateway
         *        Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
         *        <p>
         *        For information about how to set the prefixes, see <a href=
         *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         *        >Allowed Prefixes</a> in the <i>AWS Direct Connect User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>AWS Direct Connect User Guide</i>.
         * </p>
         * 
         * @param overrideAllowedPrefixesToDirectConnectGateway
         *        Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
         *        <p>
         *        For information about how to set the prefixes, see <a href=
         *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         *        >Allowed Prefixes</a> in the <i>AWS Direct Connect User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix... overrideAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>AWS Direct Connect User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteFilterPrefix>.Builder} avoiding the
         * need to create one manually via {@link List<RouteFilterPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteFilterPrefix>.Builder#build()} is called immediately
         * and its result is passed to {@link #overrideAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param overrideAllowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on {@link List<RouteFilterPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)
         */
        Builder overrideAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... overrideAllowedPrefixesToDirectConnectGateway);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String directConnectGatewayId;

        private String proposalId;

        private String associatedGatewayOwnerAccount;

        private List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptDirectConnectGatewayAssociationProposalRequest model) {
            super(model);
            directConnectGatewayId(model.directConnectGatewayId);
            proposalId(model.proposalId);
            associatedGatewayOwnerAccount(model.associatedGatewayOwnerAccount);
            overrideAllowedPrefixesToDirectConnectGateway(model.overrideAllowedPrefixesToDirectConnectGateway);
        }

        public final String getDirectConnectGatewayId() {
            return directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getProposalId() {
            return proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getAssociatedGatewayOwnerAccount() {
            return associatedGatewayOwnerAccount;
        }

        @Override
        public final Builder associatedGatewayOwnerAccount(String associatedGatewayOwnerAccount) {
            this.associatedGatewayOwnerAccount = associatedGatewayOwnerAccount;
            return this;
        }

        public final void setAssociatedGatewayOwnerAccount(String associatedGatewayOwnerAccount) {
            this.associatedGatewayOwnerAccount = associatedGatewayOwnerAccount;
        }

        public final Collection<RouteFilterPrefix.Builder> getOverrideAllowedPrefixesToDirectConnectGateway() {
            return overrideAllowedPrefixesToDirectConnectGateway != null ? overrideAllowedPrefixesToDirectConnectGateway.stream()
                    .map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copy(overrideAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... overrideAllowedPrefixesToDirectConnectGateway) {
            overrideAllowedPrefixesToDirectConnectGateway(Arrays.asList(overrideAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... overrideAllowedPrefixesToDirectConnectGateway) {
            overrideAllowedPrefixesToDirectConnectGateway(Stream.of(overrideAllowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOverrideAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(overrideAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptDirectConnectGatewayAssociationProposalRequest build() {
            return new AcceptDirectConnectGatewayAssociationProposalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
