/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLagRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, UpdateLagRequest> {
    private static final SdkField<String> LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLagRequest.getter(UpdateLagRequest::lagId)).setter(UpdateLagRequest.setter(Builder::lagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()}).build();
    private static final SdkField<String> LAG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateLagRequest.getter(UpdateLagRequest::lagName)).setter(UpdateLagRequest.setter(Builder::lagName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagName").build()}).build();
    private static final SdkField<Integer> MINIMUM_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateLagRequest.getter(UpdateLagRequest::minimumLinks)).setter(UpdateLagRequest.setter(Builder::minimumLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLinks").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAG_ID_FIELD, LAG_NAME_FIELD, MINIMUM_LINKS_FIELD));
    private final String lagId;
    private final String lagName;
    private final Integer minimumLinks;

    private UpdateLagRequest(BuilderImpl builder) {
        super(builder);
        this.lagId = builder.lagId;
        this.lagName = builder.lagName;
        this.minimumLinks = builder.minimumLinks;
    }

    public String lagId() {
        return this.lagId;
    }

    public String lagName() {
        return this.lagName;
    }

    public Integer minimumLinks() {
        return this.minimumLinks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLinks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLagRequest)) {
            return false;
        }
        UpdateLagRequest other = (UpdateLagRequest)((Object)obj);
        return Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.lagName(), other.lagName()) && Objects.equals(this.minimumLinks(), other.minimumLinks());
    }

    public String toString() {
        return ToString.builder((String)"UpdateLagRequest").add("LagId", (Object)this.lagId()).add("LagName", (Object)this.lagName()).add("MinimumLinks", (Object)this.minimumLinks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "lagName": {
                return Optional.ofNullable(clazz.cast(this.lagName()));
            }
            case "minimumLinks": {
                return Optional.ofNullable(clazz.cast(this.minimumLinks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLagRequest, T> g) {
        return obj -> g.apply((UpdateLagRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String lagId;
        private String lagName;
        private Integer minimumLinks;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLagRequest model) {
            super(model);
            this.lagId(model.lagId);
            this.lagName(model.lagName);
            this.minimumLinks(model.minimumLinks);
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getLagName() {
            return this.lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        public final Integer getMinimumLinks() {
            return this.minimumLinks;
        }

        @Override
        public final Builder minimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
            return this;
        }

        public final void setMinimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLagRequest build() {
            return new UpdateLagRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLagRequest> {
        public Builder lagId(String var1);

        public Builder lagName(String var1);

        public Builder minimumLinks(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

