/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.ConnectionState;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteConnectionResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DeleteConnectionResponse> {
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::ownerAccount)).setter(DeleteConnectionResponse.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::connectionId)).setter(DeleteConnectionResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionName").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::connectionName)).setter(DeleteConnectionResponse.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionName").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionState").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::connectionStateAsString)).setter(DeleteConnectionResponse.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::region)).setter(DeleteConnectionResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::location)).setter(DeleteConnectionResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bandwidth").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::bandwidth)).setter(DeleteConnectionResponse.setter(Builder::bandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vlan").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::vlan)).setter(DeleteConnectionResponse.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()}).build();
    private static final SdkField<String> PARTNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partnerName").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::partnerName)).setter(DeleteConnectionResponse.setter(Builder::partnerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerName").build()}).build();
    private static final SdkField<Instant> LOA_ISSUE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("loaIssueTime").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::loaIssueTime)).setter(DeleteConnectionResponse.setter(Builder::loaIssueTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaIssueTime").build()}).build();
    private static final SdkField<String> LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagId").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::lagId)).setter(DeleteConnectionResponse.setter(Builder::lagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()}).build();
    private static final SdkField<String> AWS_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDevice").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::awsDevice)).setter(DeleteConnectionResponse.setter(Builder::awsDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDevice").build()}).build();
    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("jumboFrameCapable").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::jumboFrameCapable)).setter(DeleteConnectionResponse.setter(Builder::jumboFrameCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()}).build();
    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDeviceV2").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::awsDeviceV2)).setter(DeleteConnectionResponse.setter(Builder::awsDeviceV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()}).build();
    private static final SdkField<String> HAS_LOGICAL_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hasLogicalRedundancy").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::hasLogicalRedundancyAsString)).setter(DeleteConnectionResponse.setter(Builder::hasLogicalRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasLogicalRedundancy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::tags)).setter(DeleteConnectionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(DeleteConnectionResponse.getter(DeleteConnectionResponse::providerName)).setter(DeleteConnectionResponse.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_FIELD, CONNECTION_ID_FIELD, CONNECTION_NAME_FIELD, CONNECTION_STATE_FIELD, REGION_FIELD, LOCATION_FIELD, BANDWIDTH_FIELD, VLAN_FIELD, PARTNER_NAME_FIELD, LOA_ISSUE_TIME_FIELD, LAG_ID_FIELD, AWS_DEVICE_FIELD, JUMBO_FRAME_CAPABLE_FIELD, AWS_DEVICE_V2_FIELD, HAS_LOGICAL_REDUNDANCY_FIELD, TAGS_FIELD, PROVIDER_NAME_FIELD));
    private final String ownerAccount;
    private final String connectionId;
    private final String connectionName;
    private final String connectionState;
    private final String region;
    private final String location;
    private final String bandwidth;
    private final Integer vlan;
    private final String partnerName;
    private final Instant loaIssueTime;
    private final String lagId;
    private final String awsDevice;
    private final Boolean jumboFrameCapable;
    private final String awsDeviceV2;
    private final String hasLogicalRedundancy;
    private final List<Tag> tags;
    private final String providerName;

    private DeleteConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.connectionId = builder.connectionId;
        this.connectionName = builder.connectionName;
        this.connectionState = builder.connectionState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.vlan = builder.vlan;
        this.partnerName = builder.partnerName;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.hasLogicalRedundancy = builder.hasLogicalRedundancy;
        this.tags = builder.tags;
        this.providerName = builder.providerName;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public ConnectionState connectionState() {
        return ConnectionState.fromValue(this.connectionState);
    }

    public String connectionStateAsString() {
        return this.connectionState;
    }

    public String region() {
        return this.region;
    }

    public String location() {
        return this.location;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public String partnerName() {
        return this.partnerName;
    }

    public Instant loaIssueTime() {
        return this.loaIssueTime;
    }

    public String lagId() {
        return this.lagId;
    }

    public String awsDevice() {
        return this.awsDevice;
    }

    public Boolean jumboFrameCapable() {
        return this.jumboFrameCapable;
    }

    public String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public HasLogicalRedundancy hasLogicalRedundancy() {
        return HasLogicalRedundancy.fromValue(this.hasLogicalRedundancy);
    }

    public String hasLogicalRedundancyAsString() {
        return this.hasLogicalRedundancy;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String providerName() {
        return this.providerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConnectionResponse)) {
            return false;
        }
        DeleteConnectionResponse other = (DeleteConnectionResponse)((Object)obj);
        return Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.partnerName(), other.partnerName()) && Objects.equals(this.loaIssueTime(), other.loaIssueTime()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.jumboFrameCapable(), other.jumboFrameCapable()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2()) && Objects.equals(this.hasLogicalRedundancyAsString(), other.hasLogicalRedundancyAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.providerName(), other.providerName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteConnectionResponse").add("OwnerAccount", (Object)this.ownerAccount()).add("ConnectionId", (Object)this.connectionId()).add("ConnectionName", (Object)this.connectionName()).add("ConnectionState", (Object)this.connectionStateAsString()).add("Region", (Object)this.region()).add("Location", (Object)this.location()).add("Bandwidth", (Object)this.bandwidth()).add("Vlan", (Object)this.vlan()).add("PartnerName", (Object)this.partnerName()).add("LoaIssueTime", (Object)this.loaIssueTime()).add("LagId", (Object)this.lagId()).add("AwsDevice", (Object)this.awsDevice()).add("JumboFrameCapable", (Object)this.jumboFrameCapable()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).add("HasLogicalRedundancy", (Object)this.hasLogicalRedundancyAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ProviderName", (Object)this.providerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "connectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "connectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "partnerName": {
                return Optional.ofNullable(clazz.cast(this.partnerName()));
            }
            case "loaIssueTime": {
                return Optional.ofNullable(clazz.cast(this.loaIssueTime()));
            }
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "awsDevice": {
                return Optional.ofNullable(clazz.cast(this.awsDevice()));
            }
            case "jumboFrameCapable": {
                return Optional.ofNullable(clazz.cast(this.jumboFrameCapable()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
            case "hasLogicalRedundancy": {
                return Optional.ofNullable(clazz.cast(this.hasLogicalRedundancyAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteConnectionResponse, T> g) {
        return obj -> g.apply((DeleteConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String ownerAccount;
        private String connectionId;
        private String connectionName;
        private String connectionState;
        private String region;
        private String location;
        private String bandwidth;
        private Integer vlan;
        private String partnerName;
        private Instant loaIssueTime;
        private String lagId;
        private String awsDevice;
        private Boolean jumboFrameCapable;
        private String awsDeviceV2;
        private String hasLogicalRedundancy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConnectionResponse model) {
            super(model);
            this.ownerAccount(model.ownerAccount);
            this.connectionId(model.connectionId);
            this.connectionName(model.connectionName);
            this.connectionState(model.connectionState);
            this.region(model.region);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.vlan(model.vlan);
            this.partnerName(model.partnerName);
            this.loaIssueTime(model.loaIssueTime);
            this.lagId(model.lagId);
            this.awsDevice(model.awsDevice);
            this.jumboFrameCapable(model.jumboFrameCapable);
            this.awsDeviceV2(model.awsDeviceV2);
            this.hasLogicalRedundancy(model.hasLogicalRedundancy);
            this.tags(model.tags);
            this.providerName(model.providerName);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final String getPartnerName() {
            return this.partnerName;
        }

        @Override
        public final Builder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        public final void setPartnerName(String partnerName) {
            this.partnerName = partnerName;
        }

        public final Instant getLoaIssueTime() {
            return this.loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final Boolean getJumboFrameCapable() {
            return this.jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        public final String getHasLogicalRedundancy() {
            return this.hasLogicalRedundancy;
        }

        @Override
        public final Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        @Override
        public final Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy) {
            this.hasLogicalRedundancy(hasLogicalRedundancy == null ? null : hasLogicalRedundancy.toString());
            return this;
        }

        public final void setHasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public DeleteConnectionResponse build() {
            return new DeleteConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteConnectionResponse> {
        public Builder ownerAccount(String var1);

        public Builder connectionId(String var1);

        public Builder connectionName(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(ConnectionState var1);

        public Builder region(String var1);

        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder vlan(Integer var1);

        public Builder partnerName(String var1);

        public Builder loaIssueTime(Instant var1);

        public Builder lagId(String var1);

        public Builder awsDevice(String var1);

        public Builder jumboFrameCapable(Boolean var1);

        public Builder awsDeviceV2(String var1);

        public Builder hasLogicalRedundancy(String var1);

        public Builder hasLogicalRedundancy(HasLogicalRedundancy var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder providerName(String var1);
    }
}

