/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a virtual interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateVirtualInterfaceResponse extends DirectConnectResponse implements
        ToCopyableBuilder<AssociateVirtualInterfaceResponse.Builder, AssociateVirtualInterfaceResponse> {
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(AssociateVirtualInterfaceResponse::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(AssociateVirtualInterfaceResponse::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(AssociateVirtualInterfaceResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(AssociateVirtualInterfaceResponse::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> VIRTUAL_INTERFACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceType").getter(getter(AssociateVirtualInterfaceResponse::virtualInterfaceType))
            .setter(setter(Builder::virtualInterfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceType").build())
            .build();

    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceName").getter(getter(AssociateVirtualInterfaceResponse::virtualInterfaceName))
            .setter(setter(Builder::virtualInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build())
            .build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("vlan")
            .getter(getter(AssociateVirtualInterfaceResponse::vlan)).setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()).build();

    private static final SdkField<Integer> ASN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("asn")
            .getter(getter(AssociateVirtualInterfaceResponse::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("amazonSideAsn").getter(getter(AssociateVirtualInterfaceResponse::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonSideAsn").build()).build();

    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authKey").getter(getter(AssociateVirtualInterfaceResponse::authKey)).setter(setter(Builder::authKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()).build();

    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amazonAddress").getter(getter(AssociateVirtualInterfaceResponse::amazonAddress))
            .setter(setter(Builder::amazonAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()).build();

    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerAddress").getter(getter(AssociateVirtualInterfaceResponse::customerAddress))
            .setter(setter(Builder::customerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressFamily").getter(getter(AssociateVirtualInterfaceResponse::addressFamilyAsString))
            .setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()).build();

    private static final SdkField<String> VIRTUAL_INTERFACE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceState").getter(getter(AssociateVirtualInterfaceResponse::virtualInterfaceStateAsString))
            .setter(setter(Builder::virtualInterfaceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceState").build())
            .build();

    private static final SdkField<String> CUSTOMER_ROUTER_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerRouterConfig").getter(getter(AssociateVirtualInterfaceResponse::customerRouterConfig))
            .setter(setter(Builder::customerRouterConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerRouterConfig").build())
            .build();

    private static final SdkField<Integer> MTU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("mtu")
            .getter(getter(AssociateVirtualInterfaceResponse::mtu)).setter(setter(Builder::mtu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mtu").build()).build();

    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("jumboFrameCapable").getter(getter(AssociateVirtualInterfaceResponse::jumboFrameCapable))
            .setter(setter(Builder::jumboFrameCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayId").getter(getter(AssociateVirtualInterfaceResponse::virtualGatewayId))
            .setter(setter(Builder::virtualGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()).build();

    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directConnectGatewayId").getter(getter(AssociateVirtualInterfaceResponse::directConnectGatewayId))
            .setter(setter(Builder::directConnectGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build())
            .build();

    private static final SdkField<List<RouteFilterPrefix>> ROUTE_FILTER_PREFIXES_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .memberName("routeFilterPrefixes")
            .getter(getter(AssociateVirtualInterfaceResponse::routeFilterPrefixes))
            .setter(setter(Builder::routeFilterPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeFilterPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BGPPeer>> BGP_PEERS_FIELD = SdkField
            .<List<BGPPeer>> builder(MarshallingType.LIST)
            .memberName("bgpPeers")
            .getter(getter(AssociateVirtualInterfaceResponse::bgpPeers))
            .setter(setter(Builder::bgpPeers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BGPPeer> builder(MarshallingType.SDK_POJO)
                                            .constructor(BGPPeer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(AssociateVirtualInterfaceResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsDeviceV2").getter(getter(AssociateVirtualInterfaceResponse::awsDeviceV2))
            .setter(setter(Builder::awsDeviceV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()).build();

    private static final SdkField<String> AWS_LOGICAL_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsLogicalDeviceId").getter(getter(AssociateVirtualInterfaceResponse::awsLogicalDeviceId))
            .setter(setter(Builder::awsLogicalDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogicalDeviceId").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(AssociateVirtualInterfaceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SITE_LINK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("siteLinkEnabled").getter(getter(AssociateVirtualInterfaceResponse::siteLinkEnabled))
            .setter(setter(Builder::siteLinkEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siteLinkEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(OWNER_ACCOUNT_FIELD, VIRTUAL_INTERFACE_ID_FIELD, LOCATION_FIELD, CONNECTION_ID_FIELD,
                    VIRTUAL_INTERFACE_TYPE_FIELD, VIRTUAL_INTERFACE_NAME_FIELD, VLAN_FIELD, ASN_FIELD, AMAZON_SIDE_ASN_FIELD,
                    AUTH_KEY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, ADDRESS_FAMILY_FIELD,
                    VIRTUAL_INTERFACE_STATE_FIELD, CUSTOMER_ROUTER_CONFIG_FIELD, MTU_FIELD, JUMBO_FRAME_CAPABLE_FIELD,
                    VIRTUAL_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_ID_FIELD, ROUTE_FILTER_PREFIXES_FIELD, BGP_PEERS_FIELD,
                    REGION_FIELD, AWS_DEVICE_V2_FIELD, AWS_LOGICAL_DEVICE_ID_FIELD, TAGS_FIELD, SITE_LINK_ENABLED_FIELD));

    private final String ownerAccount;

    private final String virtualInterfaceId;

    private final String location;

    private final String connectionId;

    private final String virtualInterfaceType;

    private final String virtualInterfaceName;

    private final Integer vlan;

    private final Integer asn;

    private final Long amazonSideAsn;

    private final String authKey;

    private final String amazonAddress;

    private final String customerAddress;

    private final String addressFamily;

    private final String virtualInterfaceState;

    private final String customerRouterConfig;

    private final Integer mtu;

    private final Boolean jumboFrameCapable;

    private final String virtualGatewayId;

    private final String directConnectGatewayId;

    private final List<RouteFilterPrefix> routeFilterPrefixes;

    private final List<BGPPeer> bgpPeers;

    private final String region;

    private final String awsDeviceV2;

    private final String awsLogicalDeviceId;

    private final List<Tag> tags;

    private final Boolean siteLinkEnabled;

    private AssociateVirtualInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.location = builder.location;
        this.connectionId = builder.connectionId;
        this.virtualInterfaceType = builder.virtualInterfaceType;
        this.virtualInterfaceName = builder.virtualInterfaceName;
        this.vlan = builder.vlan;
        this.asn = builder.asn;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.authKey = builder.authKey;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.addressFamily = builder.addressFamily;
        this.virtualInterfaceState = builder.virtualInterfaceState;
        this.customerRouterConfig = builder.customerRouterConfig;
        this.mtu = builder.mtu;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.virtualGatewayId = builder.virtualGatewayId;
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.routeFilterPrefixes = builder.routeFilterPrefixes;
        this.bgpPeers = builder.bgpPeers;
        this.region = builder.region;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.awsLogicalDeviceId = builder.awsLogicalDeviceId;
        this.tags = builder.tags;
        this.siteLinkEnabled = builder.siteLinkEnabled;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the virtual interface.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the virtual interface.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * <p>
     * The location of the connection.
     * </p>
     * 
     * @return The location of the connection.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.
     * </p>
     * 
     * @return The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.
     */
    public final String virtualInterfaceType() {
        return virtualInterfaceType;
    }

    /**
     * <p>
     * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters. The
     * following are valid characters: a-z, 0-9 and a hyphen (-).
     * </p>
     * 
     * @return The name of the virtual interface assigned by the customer network. The name has a maximum of 100
     *         characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
     */
    public final String virtualInterfaceName() {
        return virtualInterfaceName;
    }

    /**
     * <p>
     * The ID of the VLAN.
     * </p>
     * 
     * @return The ID of the VLAN.
     */
    public final Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * </p>
     * <p>
     * The valid values are 1-2147483647.
     * </p>
     * 
     * @return The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
     *         <p>
     *         The valid values are 1-2147483647.
     */
    public final Integer asn() {
        return asn;
    }

    /**
     * <p>
     * The autonomous system number (ASN) for the Amazon side of the connection.
     * </p>
     * 
     * @return The autonomous system number (ASN) for the Amazon side of the connection.
     */
    public final Long amazonSideAsn() {
        return amazonSideAsn;
    }

    /**
     * <p>
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun
     * lenth of 80 characters.
     * </p>
     * 
     * @return The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
     *         maximun lenth of 80 characters.
     */
    public final String authKey() {
        return authKey;
    }

    /**
     * <p>
     * The IP address assigned to the Amazon interface.
     * </p>
     * 
     * @return The IP address assigned to the Amazon interface.
     */
    public final String amazonAddress() {
        return amazonAddress;
    }

    /**
     * <p>
     * The IP address assigned to the customer interface.
     * </p>
     * 
     * @return The IP address assigned to the customer interface.
     */
    public final String customerAddress() {
        return customerAddress;
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(addressFamily);
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final String addressFamilyAsString() {
        return addressFamily;
    }

    /**
     * <p>
     * The state of the virtual interface. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface
     * owner. If the owner of the virtual interface is different from the owner of the connection on which it is
     * provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface
     * owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs
     * validation before the virtual interface can be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
     * interface is ready to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: A virtual interface that is able to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: A virtual interface that is BGP down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: A virtual interface is in this state immediately after calling
     * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: A virtual interface that cannot forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual
     * interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface
     * enters the <code>Rejected</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the virtual interface is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualInterfaceState} will return {@link VirtualInterfaceState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #virtualInterfaceStateAsString}.
     * </p>
     * 
     * @return The state of the virtual interface. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
     *         interface owner. If the owner of the virtual interface is different from the owner of the connection on
     *         which it is provisioned, then the virtual interface will remain in this state until it is confirmed by
     *         the virtual interface owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
     *         interface needs validation before the virtual interface can be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: A virtual interface is in this state from the time that it is created until the
     *         virtual interface is ready to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: A virtual interface that is able to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: A virtual interface that is BGP down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: A virtual interface is in this state immediately after calling
     *         <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: A virtual interface that cannot forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
     *         virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the
     *         virtual interface enters the <code>Rejected</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the virtual interface is not available.
     *         </p>
     *         </li>
     * @see VirtualInterfaceState
     */
    public final VirtualInterfaceState virtualInterfaceState() {
        return VirtualInterfaceState.fromValue(virtualInterfaceState);
    }

    /**
     * <p>
     * The state of the virtual interface. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface
     * owner. If the owner of the virtual interface is different from the owner of the connection on which it is
     * provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface
     * owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs
     * validation before the virtual interface can be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
     * interface is ready to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: A virtual interface that is able to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: A virtual interface that is BGP down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: A virtual interface is in this state immediately after calling
     * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: A virtual interface that cannot forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual
     * interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface
     * enters the <code>Rejected</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the virtual interface is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualInterfaceState} will return {@link VirtualInterfaceState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #virtualInterfaceStateAsString}.
     * </p>
     * 
     * @return The state of the virtual interface. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
     *         interface owner. If the owner of the virtual interface is different from the owner of the connection on
     *         which it is provisioned, then the virtual interface will remain in this state until it is confirmed by
     *         the virtual interface owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
     *         interface needs validation before the virtual interface can be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: A virtual interface is in this state from the time that it is created until the
     *         virtual interface is ready to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: A virtual interface that is able to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: A virtual interface that is BGP down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: A virtual interface is in this state immediately after calling
     *         <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: A virtual interface that cannot forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
     *         virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the
     *         virtual interface enters the <code>Rejected</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the virtual interface is not available.
     *         </p>
     *         </li>
     * @see VirtualInterfaceState
     */
    public final String virtualInterfaceStateAsString() {
        return virtualInterfaceState;
    }

    /**
     * <p>
     * The customer router configuration.
     * </p>
     * 
     * @return The customer router configuration.
     */
    public final String customerRouterConfig() {
        return customerRouterConfig;
    }

    /**
     * <p>
     * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is 1500.
     * </p>
     * 
     * @return The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value
     *         is 1500.
     */
    public final Integer mtu() {
        return mtu;
    }

    /**
     * <p>
     * Indicates whether jumbo frames (9001 MTU) are supported.
     * </p>
     * 
     * @return Indicates whether jumbo frames (9001 MTU) are supported.
     */
    public final Boolean jumboFrameCapable() {
        return jumboFrameCapable;
    }

    /**
     * <p>
     * The ID of the virtual private gateway. Applies only to private virtual interfaces.
     * </p>
     * 
     * @return The ID of the virtual private gateway. Applies only to private virtual interfaces.
     */
    public final String virtualGatewayId() {
        return virtualGatewayId;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway.
     */
    public final String directConnectGatewayId() {
        return directConnectGatewayId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteFilterPrefixes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteFilterPrefixes() {
        return routeFilterPrefixes != null && !(routeFilterPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
     * interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteFilterPrefixes} method.
     * </p>
     * 
     * @return The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
     *         interfaces.
     */
    public final List<RouteFilterPrefix> routeFilterPrefixes() {
        return routeFilterPrefixes;
    }

    /**
     * For responses, this returns true if the service returned a value for the BgpPeers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBgpPeers() {
        return bgpPeers != null && !(bgpPeers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The BGP peers configured on this virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBgpPeers} method.
     * </p>
     * 
     * @return The BGP peers configured on this virtual interface.
     */
    public final List<BGPPeer> bgpPeers() {
        return bgpPeers;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the virtual interface is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the virtual interface is located.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The Direct Connect endpoint that terminates the physical connection.
     * </p>
     * 
     * @return The Direct Connect endpoint that terminates the physical connection.
     */
    public final String awsDeviceV2() {
        return awsDeviceV2;
    }

    /**
     * <p>
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the
     * device that terminates the physical connection.
     * </p>
     * 
     * @return The Direct Connect endpoint that terminates the logical connection. This device might be different than
     *         the device that terminates the physical connection.
     */
    public final String awsLogicalDeviceId() {
        return awsLogicalDeviceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the virtual interface.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether SiteLink is enabled.
     * </p>
     * 
     * @return Indicates whether SiteLink is enabled.
     */
    public final Boolean siteLinkEnabled() {
        return siteLinkEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(authKey());
        hashCode = 31 * hashCode + Objects.hashCode(amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customerRouterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(mtu());
        hashCode = 31 * hashCode + Objects.hashCode(jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteFilterPrefixes() ? routeFilterPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBgpPeers() ? bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(awsLogicalDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(siteLinkEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVirtualInterfaceResponse)) {
            return false;
        }
        AssociateVirtualInterfaceResponse other = (AssociateVirtualInterfaceResponse) obj;
        return Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(virtualInterfaceId(), other.virtualInterfaceId())
                && Objects.equals(location(), other.location()) && Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(virtualInterfaceType(), other.virtualInterfaceType())
                && Objects.equals(virtualInterfaceName(), other.virtualInterfaceName()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(asn(), other.asn()) && Objects.equals(amazonSideAsn(), other.amazonSideAsn())
                && Objects.equals(authKey(), other.authKey()) && Objects.equals(amazonAddress(), other.amazonAddress())
                && Objects.equals(customerAddress(), other.customerAddress())
                && Objects.equals(addressFamilyAsString(), other.addressFamilyAsString())
                && Objects.equals(virtualInterfaceStateAsString(), other.virtualInterfaceStateAsString())
                && Objects.equals(customerRouterConfig(), other.customerRouterConfig()) && Objects.equals(mtu(), other.mtu())
                && Objects.equals(jumboFrameCapable(), other.jumboFrameCapable())
                && Objects.equals(virtualGatewayId(), other.virtualGatewayId())
                && Objects.equals(directConnectGatewayId(), other.directConnectGatewayId())
                && hasRouteFilterPrefixes() == other.hasRouteFilterPrefixes()
                && Objects.equals(routeFilterPrefixes(), other.routeFilterPrefixes()) && hasBgpPeers() == other.hasBgpPeers()
                && Objects.equals(bgpPeers(), other.bgpPeers()) && Objects.equals(region(), other.region())
                && Objects.equals(awsDeviceV2(), other.awsDeviceV2())
                && Objects.equals(awsLogicalDeviceId(), other.awsLogicalDeviceId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(siteLinkEnabled(), other.siteLinkEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateVirtualInterfaceResponse").add("OwnerAccount", ownerAccount())
                .add("VirtualInterfaceId", virtualInterfaceId()).add("Location", location()).add("ConnectionId", connectionId())
                .add("VirtualInterfaceType", virtualInterfaceType()).add("VirtualInterfaceName", virtualInterfaceName())
                .add("Vlan", vlan()).add("Asn", asn()).add("AmazonSideAsn", amazonSideAsn()).add("AuthKey", authKey())
                .add("AmazonAddress", amazonAddress()).add("CustomerAddress", customerAddress())
                .add("AddressFamily", addressFamilyAsString()).add("VirtualInterfaceState", virtualInterfaceStateAsString())
                .add("CustomerRouterConfig", customerRouterConfig()).add("Mtu", mtu())
                .add("JumboFrameCapable", jumboFrameCapable()).add("VirtualGatewayId", virtualGatewayId())
                .add("DirectConnectGatewayId", directConnectGatewayId())
                .add("RouteFilterPrefixes", hasRouteFilterPrefixes() ? routeFilterPrefixes() : null)
                .add("BgpPeers", hasBgpPeers() ? bgpPeers() : null).add("Region", region()).add("AwsDeviceV2", awsDeviceV2())
                .add("AwsLogicalDeviceId", awsLogicalDeviceId()).add("Tags", hasTags() ? tags() : null)
                .add("SiteLinkEnabled", siteLinkEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "virtualInterfaceType":
            return Optional.ofNullable(clazz.cast(virtualInterfaceType()));
        case "virtualInterfaceName":
            return Optional.ofNullable(clazz.cast(virtualInterfaceName()));
        case "vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "amazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        case "authKey":
            return Optional.ofNullable(clazz.cast(authKey()));
        case "amazonAddress":
            return Optional.ofNullable(clazz.cast(amazonAddress()));
        case "customerAddress":
            return Optional.ofNullable(clazz.cast(customerAddress()));
        case "addressFamily":
            return Optional.ofNullable(clazz.cast(addressFamilyAsString()));
        case "virtualInterfaceState":
            return Optional.ofNullable(clazz.cast(virtualInterfaceStateAsString()));
        case "customerRouterConfig":
            return Optional.ofNullable(clazz.cast(customerRouterConfig()));
        case "mtu":
            return Optional.ofNullable(clazz.cast(mtu()));
        case "jumboFrameCapable":
            return Optional.ofNullable(clazz.cast(jumboFrameCapable()));
        case "virtualGatewayId":
            return Optional.ofNullable(clazz.cast(virtualGatewayId()));
        case "directConnectGatewayId":
            return Optional.ofNullable(clazz.cast(directConnectGatewayId()));
        case "routeFilterPrefixes":
            return Optional.ofNullable(clazz.cast(routeFilterPrefixes()));
        case "bgpPeers":
            return Optional.ofNullable(clazz.cast(bgpPeers()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "awsDeviceV2":
            return Optional.ofNullable(clazz.cast(awsDeviceV2()));
        case "awsLogicalDeviceId":
            return Optional.ofNullable(clazz.cast(awsLogicalDeviceId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "siteLinkEnabled":
            return Optional.ofNullable(clazz.cast(siteLinkEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateVirtualInterfaceResponse, T> g) {
        return obj -> g.apply((AssociateVirtualInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateVirtualInterfaceResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the virtual interface.
         * </p>
         * 
         * @param ownerAccount
         *        The ID of the Amazon Web Services account that owns the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * The location of the connection.
         * </p>
         * 
         * @param location
         *        The location of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.
         * </p>
         * 
         * @param virtualInterfaceType
         *        The type of virtual interface. The possible values are <code>private</code> and <code>public</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceType(String virtualInterfaceType);

        /**
         * <p>
         * The name of the virtual interface assigned by the customer network. The name has a maximum of 100 characters.
         * The following are valid characters: a-z, 0-9 and a hyphen (-).
         * </p>
         * 
         * @param virtualInterfaceName
         *        The name of the virtual interface assigned by the customer network. The name has a maximum of 100
         *        characters. The following are valid characters: a-z, 0-9 and a hyphen (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceName(String virtualInterfaceName);

        /**
         * <p>
         * The ID of the VLAN.
         * </p>
         * 
         * @param vlan
         *        The ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * </p>
         * <p>
         * The valid values are 1-2147483647.
         * </p>
         * 
         * @param asn
         *        The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.</p>
         *        <p>
         *        The valid values are 1-2147483647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Integer asn);

        /**
         * <p>
         * The autonomous system number (ASN) for the Amazon side of the connection.
         * </p>
         * 
         * @param amazonSideAsn
         *        The autonomous system number (ASN) for the Amazon side of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);

        /**
         * <p>
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
         * maximun lenth of 80 characters.
         * </p>
         * 
         * @param authKey
         *        The authentication key for BGP configuration. This string has a minimum length of 6 characters and and
         *        a maximun lenth of 80 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authKey(String authKey);

        /**
         * <p>
         * The IP address assigned to the Amazon interface.
         * </p>
         * 
         * @param amazonAddress
         *        The IP address assigned to the Amazon interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonAddress(String amazonAddress);

        /**
         * <p>
         * The IP address assigned to the customer interface.
         * </p>
         * 
         * @param customerAddress
         *        The IP address assigned to the customer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAddress(String customerAddress);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(AddressFamily addressFamily);

        /**
         * <p>
         * The state of the virtual interface. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
         * interface owner. If the owner of the virtual interface is different from the owner of the connection on which
         * it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual
         * interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface
         * needs validation before the virtual interface can be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
         * interface is ready to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: A virtual interface that is able to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: A virtual interface that is BGP down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: A virtual interface is in this state immediately after calling
         * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: A virtual interface that cannot forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
         * virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual
         * interface enters the <code>Rejected</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the virtual interface is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param virtualInterfaceState
         *        The state of the virtual interface. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>confirming</code>: The creation of the virtual interface is pending confirmation from the
         *        virtual interface owner. If the owner of the virtual interface is different from the owner of the
         *        connection on which it is provisioned, then the virtual interface will remain in this state until it
         *        is confirmed by the virtual interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
         *        interface needs validation before the virtual interface can be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: A virtual interface is in this state from the time that it is created until the
         *        virtual interface is ready to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: A virtual interface that is able to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: A virtual interface that is BGP down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: A virtual interface is in this state immediately after calling
         *        <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: A virtual interface that cannot forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If
         *        a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner,
         *        the virtual interface enters the <code>Rejected</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the virtual interface is not available.
         *        </p>
         *        </li>
         * @see VirtualInterfaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualInterfaceState
         */
        Builder virtualInterfaceState(String virtualInterfaceState);

        /**
         * <p>
         * The state of the virtual interface. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
         * interface owner. If the owner of the virtual interface is different from the owner of the connection on which
         * it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual
         * interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface
         * needs validation before the virtual interface can be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
         * interface is ready to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: A virtual interface that is able to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: A virtual interface that is BGP down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: A virtual interface is in this state immediately after calling
         * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: A virtual interface that cannot forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
         * virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual
         * interface enters the <code>Rejected</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the virtual interface is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param virtualInterfaceState
         *        The state of the virtual interface. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>confirming</code>: The creation of the virtual interface is pending confirmation from the
         *        virtual interface owner. If the owner of the virtual interface is different from the owner of the
         *        connection on which it is provisioned, then the virtual interface will remain in this state until it
         *        is confirmed by the virtual interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
         *        interface needs validation before the virtual interface can be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: A virtual interface is in this state from the time that it is created until the
         *        virtual interface is ready to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: A virtual interface that is able to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: A virtual interface that is BGP down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: A virtual interface is in this state immediately after calling
         *        <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: A virtual interface that cannot forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If
         *        a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner,
         *        the virtual interface enters the <code>Rejected</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the virtual interface is not available.
         *        </p>
         *        </li>
         * @see VirtualInterfaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualInterfaceState
         */
        Builder virtualInterfaceState(VirtualInterfaceState virtualInterfaceState);

        /**
         * <p>
         * The customer router configuration.
         * </p>
         * 
         * @param customerRouterConfig
         *        The customer router configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerRouterConfig(String customerRouterConfig);

        /**
         * <p>
         * The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default value is
         * 1500.
         * </p>
         * 
         * @param mtu
         *        The maximum transmission unit (MTU), in bytes. The supported values are 1500 and 9001. The default
         *        value is 1500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mtu(Integer mtu);

        /**
         * <p>
         * Indicates whether jumbo frames (9001 MTU) are supported.
         * </p>
         * 
         * @param jumboFrameCapable
         *        Indicates whether jumbo frames (9001 MTU) are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jumboFrameCapable(Boolean jumboFrameCapable);

        /**
         * <p>
         * The ID of the virtual private gateway. Applies only to private virtual interfaces.
         * </p>
         * 
         * @param virtualGatewayId
         *        The ID of the virtual private gateway. Applies only to private virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayId(String virtualGatewayId);

        /**
         * <p>
         * The ID of the Direct Connect gateway.
         * </p>
         * 
         * @param directConnectGatewayId
         *        The ID of the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayId(String directConnectGatewayId);

        /**
         * <p>
         * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
         * interfaces.
         * </p>
         * 
         * @param routeFilterPrefixes
         *        The routes to be advertised to the Amazon Web Services network in this Region. Applies to public
         *        virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes);

        /**
         * <p>
         * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
         * interfaces.
         * </p>
         * 
         * @param routeFilterPrefixes
         *        The routes to be advertised to the Amazon Web Services network in this Region. Applies to public
         *        virtual interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeFilterPrefixes(RouteFilterPrefix... routeFilterPrefixes);

        /**
         * <p>
         * The routes to be advertised to the Amazon Web Services network in this Region. Applies to public virtual
         * interfaces.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder#build()} is called
         * immediately and its result is passed to {@link #routeFilterPrefixes(List<RouteFilterPrefix>)}.
         * 
         * @param routeFilterPrefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeFilterPrefixes(java.util.Collection<RouteFilterPrefix>)
         */
        Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder>... routeFilterPrefixes);

        /**
         * <p>
         * The BGP peers configured on this virtual interface.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers configured on this virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(Collection<BGPPeer> bgpPeers);

        /**
         * <p>
         * The BGP peers configured on this virtual interface.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers configured on this virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(BGPPeer... bgpPeers);

        /**
         * <p>
         * The BGP peers configured on this virtual interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.BGPPeer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.directconnect.model.BGPPeer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.BGPPeer.Builder#build()} is called immediately and
         * its result is passed to {@link #bgpPeers(List<BGPPeer>)}.
         * 
         * @param bgpPeers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.BGPPeer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bgpPeers(java.util.Collection<BGPPeer>)
         */
        Builder bgpPeers(Consumer<BGPPeer.Builder>... bgpPeers);

        /**
         * <p>
         * The Amazon Web Services Region where the virtual interface is located.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the virtual interface is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The Direct Connect endpoint that terminates the physical connection.
         * </p>
         * 
         * @param awsDeviceV2
         *        The Direct Connect endpoint that terminates the physical connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDeviceV2(String awsDeviceV2);

        /**
         * <p>
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the
         * device that terminates the physical connection.
         * </p>
         * 
         * @param awsLogicalDeviceId
         *        The Direct Connect endpoint that terminates the logical connection. This device might be different
         *        than the device that terminates the physical connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLogicalDeviceId(String awsLogicalDeviceId);

        /**
         * <p>
         * The tags associated with the virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the virtual interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.directconnect.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether SiteLink is enabled.
         * </p>
         * 
         * @param siteLinkEnabled
         *        Indicates whether SiteLink is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteLinkEnabled(Boolean siteLinkEnabled);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String ownerAccount;

        private String virtualInterfaceId;

        private String location;

        private String connectionId;

        private String virtualInterfaceType;

        private String virtualInterfaceName;

        private Integer vlan;

        private Integer asn;

        private Long amazonSideAsn;

        private String authKey;

        private String amazonAddress;

        private String customerAddress;

        private String addressFamily;

        private String virtualInterfaceState;

        private String customerRouterConfig;

        private Integer mtu;

        private Boolean jumboFrameCapable;

        private String virtualGatewayId;

        private String directConnectGatewayId;

        private List<RouteFilterPrefix> routeFilterPrefixes = DefaultSdkAutoConstructList.getInstance();

        private List<BGPPeer> bgpPeers = DefaultSdkAutoConstructList.getInstance();

        private String region;

        private String awsDeviceV2;

        private String awsLogicalDeviceId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean siteLinkEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVirtualInterfaceResponse model) {
            super(model);
            ownerAccount(model.ownerAccount);
            virtualInterfaceId(model.virtualInterfaceId);
            location(model.location);
            connectionId(model.connectionId);
            virtualInterfaceType(model.virtualInterfaceType);
            virtualInterfaceName(model.virtualInterfaceName);
            vlan(model.vlan);
            asn(model.asn);
            amazonSideAsn(model.amazonSideAsn);
            authKey(model.authKey);
            amazonAddress(model.amazonAddress);
            customerAddress(model.customerAddress);
            addressFamily(model.addressFamily);
            virtualInterfaceState(model.virtualInterfaceState);
            customerRouterConfig(model.customerRouterConfig);
            mtu(model.mtu);
            jumboFrameCapable(model.jumboFrameCapable);
            virtualGatewayId(model.virtualGatewayId);
            directConnectGatewayId(model.directConnectGatewayId);
            routeFilterPrefixes(model.routeFilterPrefixes);
            bgpPeers(model.bgpPeers);
            region(model.region);
            awsDeviceV2(model.awsDeviceV2);
            awsLogicalDeviceId(model.awsLogicalDeviceId);
            tags(model.tags);
            siteLinkEnabled(model.siteLinkEnabled);
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getVirtualInterfaceType() {
            return virtualInterfaceType;
        }

        public final void setVirtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
        }

        @Override
        public final Builder virtualInterfaceType(String virtualInterfaceType) {
            this.virtualInterfaceType = virtualInterfaceType;
            return this;
        }

        public final String getVirtualInterfaceName() {
            return virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        public final Integer getVlan() {
            return vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final Integer getAsn() {
            return asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final String getAuthKey() {
            return authKey;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final String getAmazonAddress() {
            return amazonAddress;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final String getCustomerAddress() {
            return customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final String getVirtualInterfaceState() {
            return virtualInterfaceState;
        }

        public final void setVirtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
        }

        @Override
        public final Builder virtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
            return this;
        }

        @Override
        public final Builder virtualInterfaceState(VirtualInterfaceState virtualInterfaceState) {
            this.virtualInterfaceState(virtualInterfaceState == null ? null : virtualInterfaceState.toString());
            return this;
        }

        public final String getCustomerRouterConfig() {
            return customerRouterConfig;
        }

        public final void setCustomerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
        }

        @Override
        public final Builder customerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
            return this;
        }

        public final Integer getMtu() {
            return mtu;
        }

        public final void setMtu(Integer mtu) {
            this.mtu = mtu;
        }

        @Override
        public final Builder mtu(Integer mtu) {
            this.mtu = mtu;
            return this;
        }

        public final Boolean getJumboFrameCapable() {
            return jumboFrameCapable;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final String getVirtualGatewayId() {
            return virtualGatewayId;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final String getDirectConnectGatewayId() {
            return directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final List<RouteFilterPrefix.Builder> getRouteFilterPrefixes() {
            List<RouteFilterPrefix.Builder> result = RouteFilterPrefixListCopier.copyToBuilder(this.routeFilterPrefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteFilterPrefixes(Collection<RouteFilterPrefix.BuilderImpl> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copyFromBuilder(routeFilterPrefixes);
        }

        @Override
        public final Builder routeFilterPrefixes(Collection<RouteFilterPrefix> routeFilterPrefixes) {
            this.routeFilterPrefixes = RouteFilterPrefixListCopier.copy(routeFilterPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(RouteFilterPrefix... routeFilterPrefixes) {
            routeFilterPrefixes(Arrays.asList(routeFilterPrefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeFilterPrefixes(Consumer<RouteFilterPrefix.Builder>... routeFilterPrefixes) {
            routeFilterPrefixes(Stream.of(routeFilterPrefixes).map(c -> RouteFilterPrefix.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BGPPeer.Builder> getBgpPeers() {
            List<BGPPeer.Builder> result = BGPPeerListCopier.copyToBuilder(this.bgpPeers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBgpPeers(Collection<BGPPeer.BuilderImpl> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copyFromBuilder(bgpPeers);
        }

        @Override
        public final Builder bgpPeers(Collection<BGPPeer> bgpPeers) {
            this.bgpPeers = BGPPeerListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(BGPPeer... bgpPeers) {
            bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(Consumer<BGPPeer.Builder>... bgpPeers) {
            bgpPeers(Stream.of(bgpPeers).map(c -> BGPPeer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAwsDeviceV2() {
            return awsDeviceV2;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final String getAwsLogicalDeviceId() {
            return awsLogicalDeviceId;
        }

        public final void setAwsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
        }

        @Override
        public final Builder awsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSiteLinkEnabled() {
            return siteLinkEnabled;
        }

        public final void setSiteLinkEnabled(Boolean siteLinkEnabled) {
            this.siteLinkEnabled = siteLinkEnabled;
        }

        @Override
        public final Builder siteLinkEnabled(Boolean siteLinkEnabled) {
            this.siteLinkEnabled = siteLinkEnabled;
            return this;
        }

        @Override
        public AssociateVirtualInterfaceResponse build() {
            return new AssociateVirtualInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
