/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBgpFailoverTestRequest extends DirectConnectRequest implements
        ToCopyableBuilder<StartBgpFailoverTestRequest.Builder, StartBgpFailoverTestRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(StartBgpFailoverTestRequest::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<List<String>> BGP_PEERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("bgpPeers")
            .getter(getter(StartBgpFailoverTestRequest::bgpPeers))
            .setter(setter(Builder::bgpPeers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TEST_DURATION_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testDurationInMinutes").getter(getter(StartBgpFailoverTestRequest::testDurationInMinutes))
            .setter(setter(Builder::testDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testDurationInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD,
            BGP_PEERS_FIELD, TEST_DURATION_IN_MINUTES_FIELD));

    private final String virtualInterfaceId;

    private final List<String> bgpPeers;

    private final Integer testDurationInMinutes;

    private StartBgpFailoverTestRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.bgpPeers = builder.bgpPeers;
        this.testDurationInMinutes = builder.testDurationInMinutes;
    }

    /**
     * <p>
     * The ID of the virtual interface you want to test.
     * </p>
     * 
     * @return The ID of the virtual interface you want to test.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BgpPeers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBgpPeers() {
        return bgpPeers != null && !(bgpPeers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The BGP peers to place in the DOWN state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBgpPeers} method.
     * </p>
     * 
     * @return The BGP peers to place in the DOWN state.
     */
    public final List<String> bgpPeers() {
        return bgpPeers;
    }

    /**
     * <p>
     * The time in minutes that the virtual interface failover test will last.
     * </p>
     * <p>
     * Maximum value: 180 minutes (3 hours).
     * </p>
     * <p>
     * Default: 180 minutes (3 hours).
     * </p>
     * 
     * @return The time in minutes that the virtual interface failover test will last.</p>
     *         <p>
     *         Maximum value: 180 minutes (3 hours).
     *         </p>
     *         <p>
     *         Default: 180 minutes (3 hours).
     */
    public final Integer testDurationInMinutes() {
        return testDurationInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBgpPeers() ? bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(testDurationInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBgpFailoverTestRequest)) {
            return false;
        }
        StartBgpFailoverTestRequest other = (StartBgpFailoverTestRequest) obj;
        return Objects.equals(virtualInterfaceId(), other.virtualInterfaceId()) && hasBgpPeers() == other.hasBgpPeers()
                && Objects.equals(bgpPeers(), other.bgpPeers())
                && Objects.equals(testDurationInMinutes(), other.testDurationInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBgpFailoverTestRequest").add("VirtualInterfaceId", virtualInterfaceId())
                .add("BgpPeers", hasBgpPeers() ? bgpPeers() : null).add("TestDurationInMinutes", testDurationInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "bgpPeers":
            return Optional.ofNullable(clazz.cast(bgpPeers()));
        case "testDurationInMinutes":
            return Optional.ofNullable(clazz.cast(testDurationInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBgpFailoverTestRequest, T> g) {
        return obj -> g.apply((StartBgpFailoverTestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartBgpFailoverTestRequest> {
        /**
         * <p>
         * The ID of the virtual interface you want to test.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual interface you want to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * The BGP peers to place in the DOWN state.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers to place in the DOWN state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(Collection<String> bgpPeers);

        /**
         * <p>
         * The BGP peers to place in the DOWN state.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers to place in the DOWN state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(String... bgpPeers);

        /**
         * <p>
         * The time in minutes that the virtual interface failover test will last.
         * </p>
         * <p>
         * Maximum value: 180 minutes (3 hours).
         * </p>
         * <p>
         * Default: 180 minutes (3 hours).
         * </p>
         * 
         * @param testDurationInMinutes
         *        The time in minutes that the virtual interface failover test will last.</p>
         *        <p>
         *        Maximum value: 180 minutes (3 hours).
         *        </p>
         *        <p>
         *        Default: 180 minutes (3 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testDurationInMinutes(Integer testDurationInMinutes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String virtualInterfaceId;

        private List<String> bgpPeers = DefaultSdkAutoConstructList.getInstance();

        private Integer testDurationInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBgpFailoverTestRequest model) {
            super(model);
            virtualInterfaceId(model.virtualInterfaceId);
            bgpPeers(model.bgpPeers);
            testDurationInMinutes(model.testDurationInMinutes);
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Collection<String> getBgpPeers() {
            if (bgpPeers instanceof SdkAutoConstructList) {
                return null;
            }
            return bgpPeers;
        }

        public final void setBgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
        }

        @Override
        public final Builder bgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpPeers(String... bgpPeers) {
            bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final Integer getTestDurationInMinutes() {
            return testDurationInMinutes;
        }

        public final void setTestDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
        }

        @Override
        public final Builder testDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBgpFailoverTestRequest build() {
            return new StartBgpFailoverTestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
