/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BGPStatus {
    UP("up"),
    DOWN("down"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BGPStatus> VALUE_MAP;
    private final String value;

    private BGPStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BGPStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BGPStatus> knownValues() {
        EnumSet<BGPStatus> knownValues = EnumSet.allOf(BGPStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BGPStatus.class, BGPStatus::toString);
    }
}

