/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the MAC Security (MACsec) secret key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MacSecKey implements SdkPojo, Serializable, ToCopyableBuilder<MacSecKey.Builder, MacSecKey> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretARN").getter(getter(MacSecKey::secretARN)).setter(setter(Builder::secretARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretARN").build()).build();

    private static final SdkField<String> CKN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ckn")
            .getter(getter(MacSecKey::ckn)).setter(setter(Builder::ckn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ckn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(MacSecKey::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> START_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startOn").getter(getter(MacSecKey::startOn)).setter(setter(Builder::startOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD, CKN_FIELD,
            STATE_FIELD, START_ON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String secretARN;

    private final String ckn;

    private final String state;

    private final String startOn;

    private MacSecKey(BuilderImpl builder) {
        this.secretARN = builder.secretARN;
        this.ckn = builder.ckn;
        this.state = builder.state;
        this.startOn = builder.startOn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
     */
    public final String secretARN() {
        return secretARN;
    }

    /**
     * <p>
     * The Connection Key Name (CKN) for the MAC Security secret key.
     * </p>
     * 
     * @return The Connection Key Name (CKN) for the MAC Security secret key.
     */
    public final String ckn() {
        return ckn;
    }

    /**
     * <p>
     * The state of the MAC Security (MACsec) secret key.
     * </p>
     * <p>
     * The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet associated with the
     * connection or LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the connection or
     * LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the connection or
     * LAG
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the connection or
     * LAG.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The state of the MAC Security (MACsec) secret key.</p>
     *         <p>
     *         The possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet associated
     *         with the connection or LAG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the
     *         connection or LAG.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the
     *         connection or LAG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the
     *         connection or LAG.
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.
     * </p>
     * 
     * @return The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.
     */
    public final String startOn() {
        return startOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretARN());
        hashCode = 31 * hashCode + Objects.hashCode(ckn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(startOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacSecKey)) {
            return false;
        }
        MacSecKey other = (MacSecKey) obj;
        return Objects.equals(secretARN(), other.secretARN()) && Objects.equals(ckn(), other.ckn())
                && Objects.equals(state(), other.state()) && Objects.equals(startOn(), other.startOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MacSecKey").add("SecretARN", secretARN()).add("Ckn", ckn()).add("State", state())
                .add("StartOn", startOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretARN":
            return Optional.ofNullable(clazz.cast(secretARN()));
        case "ckn":
            return Optional.ofNullable(clazz.cast(ckn()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "startOn":
            return Optional.ofNullable(clazz.cast(startOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MacSecKey, T> g) {
        return obj -> g.apply((MacSecKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MacSecKey> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
         * </p>
         * 
         * @param secretARN
         *        The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretARN(String secretARN);

        /**
         * <p>
         * The Connection Key Name (CKN) for the MAC Security secret key.
         * </p>
         * 
         * @param ckn
         *        The Connection Key Name (CKN) for the MAC Security secret key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ckn(String ckn);

        /**
         * <p>
         * The state of the MAC Security (MACsec) secret key.
         * </p>
         * <p>
         * The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet associated with
         * the connection or LAG.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the connection
         * or LAG.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the connection
         * or LAG
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the connection
         * or LAG.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the MAC Security (MACsec) secret key.</p>
         *        <p>
         *        The possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>associating</code>: The MAC Security (MACsec) secret key is being validated and not yet
         *        associated with the connection or LAG.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>associated</code>: The MAC Security (MACsec) secret key is validated and associated with the
         *        connection or LAG.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>disassociating</code>: The MAC Security (MACsec) secret key is being disassociated from the
         *        connection or LAG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>disassociated</code>: The MAC Security (MACsec) secret key is no longer associated with the
         *        connection or LAG.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.
         * </p>
         * 
         * @param startOn
         *        The date that the MAC Security (MACsec) secret key takes effect. The value is displayed in UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startOn(String startOn);
    }

    static final class BuilderImpl implements Builder {
        private String secretARN;

        private String ckn;

        private String state;

        private String startOn;

        private BuilderImpl() {
        }

        private BuilderImpl(MacSecKey model) {
            secretARN(model.secretARN);
            ckn(model.ckn);
            state(model.state);
            startOn(model.startOn);
        }

        public final String getSecretARN() {
            return secretARN;
        }

        public final void setSecretARN(String secretARN) {
            this.secretARN = secretARN;
        }

        @Override
        public final Builder secretARN(String secretARN) {
            this.secretARN = secretARN;
            return this;
        }

        public final String getCkn() {
            return ckn;
        }

        public final void setCkn(String ckn) {
            this.ckn = ckn;
        }

        @Override
        public final Builder ckn(String ckn) {
            this.ckn = ckn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStartOn() {
            return startOn;
        }

        public final void setStartOn(String startOn) {
            this.startOn = startOn;
        }

        @Override
        public final Builder startOn(String startOn) {
            this.startOn = startOn;
            return this;
        }

        @Override
        public MacSecKey build() {
            return new MacSecKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
