/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a new BGP peer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewBGPPeer implements SdkPojo, Serializable, ToCopyableBuilder<NewBGPPeer.Builder, NewBGPPeer> {
    private static final SdkField<Integer> ASN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("asn")
            .getter(getter(NewBGPPeer::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authKey").getter(getter(NewBGPPeer::authKey)).setter(setter(Builder::authKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressFamily").getter(getter(NewBGPPeer::addressFamilyAsString)).setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()).build();

    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amazonAddress").getter(getter(NewBGPPeer::amazonAddress)).setter(setter(Builder::amazonAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()).build();

    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerAddress").getter(getter(NewBGPPeer::customerAddress)).setter(setter(Builder::customerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_FIELD, AUTH_KEY_FIELD,
            ADDRESS_FAMILY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer asn;

    private final String authKey;

    private final String addressFamily;

    private final String amazonAddress;

    private final String customerAddress;

    private NewBGPPeer(BuilderImpl builder) {
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.addressFamily = builder.addressFamily;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
    }

    /**
     * <p>
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * </p>
     * 
     * @return The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public final Integer asn() {
        return asn;
    }

    /**
     * <p>
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun
     * lenth of 80 characters.
     * </p>
     * 
     * @return The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
     *         maximun lenth of 80 characters.
     */
    public final String authKey() {
        return authKey;
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(addressFamily);
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final String addressFamilyAsString() {
        return addressFamily;
    }

    /**
     * <p>
     * The IP address assigned to the Amazon interface.
     * </p>
     * 
     * @return The IP address assigned to the Amazon interface.
     */
    public final String amazonAddress() {
        return amazonAddress;
    }

    /**
     * <p>
     * The IP address assigned to the customer interface.
     * </p>
     * 
     * @return The IP address assigned to the customer interface.
     */
    public final String customerAddress() {
        return customerAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(authKey());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(customerAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewBGPPeer)) {
            return false;
        }
        NewBGPPeer other = (NewBGPPeer) obj;
        return Objects.equals(asn(), other.asn()) && Objects.equals(authKey(), other.authKey())
                && Objects.equals(addressFamilyAsString(), other.addressFamilyAsString())
                && Objects.equals(amazonAddress(), other.amazonAddress())
                && Objects.equals(customerAddress(), other.customerAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewBGPPeer").add("Asn", asn()).add("AuthKey", authKey())
                .add("AddressFamily", addressFamilyAsString()).add("AmazonAddress", amazonAddress())
                .add("CustomerAddress", customerAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "authKey":
            return Optional.ofNullable(clazz.cast(authKey()));
        case "addressFamily":
            return Optional.ofNullable(clazz.cast(addressFamilyAsString()));
        case "amazonAddress":
            return Optional.ofNullable(clazz.cast(amazonAddress()));
        case "customerAddress":
            return Optional.ofNullable(clazz.cast(customerAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewBGPPeer, T> g) {
        return obj -> g.apply((NewBGPPeer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewBGPPeer> {
        /**
         * <p>
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * </p>
         * 
         * @param asn
         *        The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Integer asn);

        /**
         * <p>
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
         * maximun lenth of 80 characters.
         * </p>
         * 
         * @param authKey
         *        The authentication key for BGP configuration. This string has a minimum length of 6 characters and and
         *        a maximun lenth of 80 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authKey(String authKey);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(AddressFamily addressFamily);

        /**
         * <p>
         * The IP address assigned to the Amazon interface.
         * </p>
         * 
         * @param amazonAddress
         *        The IP address assigned to the Amazon interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonAddress(String amazonAddress);

        /**
         * <p>
         * The IP address assigned to the customer interface.
         * </p>
         * 
         * @param customerAddress
         *        The IP address assigned to the customer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAddress(String customerAddress);
    }

    static final class BuilderImpl implements Builder {
        private Integer asn;

        private String authKey;

        private String addressFamily;

        private String amazonAddress;

        private String customerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NewBGPPeer model) {
            asn(model.asn);
            authKey(model.authKey);
            addressFamily(model.addressFamily);
            amazonAddress(model.amazonAddress);
            customerAddress(model.customerAddress);
        }

        public final Integer getAsn() {
            return asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final String getAuthKey() {
            return authKey;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final String getAmazonAddress() {
            return amazonAddress;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final String getCustomerAddress() {
            return customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        @Override
        public NewBGPPeer build() {
            return new NewBGPPeer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
