/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.MonthDay;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class MonthDayAttributeConverter
implements AttributeConverter<MonthDay> {
    private static final Visitor VISITOR = new Visitor();

    private MonthDayAttributeConverter() {
    }

    public static MonthDayAttributeConverter create() {
        return new MonthDayAttributeConverter();
    }

    @Override
    public EnhancedType<MonthDay> type() {
        return EnhancedType.of(MonthDay.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(MonthDay input) {
        return (AttributeValue)AttributeValue.builder().s(input.toString()).build();
    }

    @Override
    public MonthDay transformTo(AttributeValue input) {
        try {
            if (input.s() != null) {
                return EnhancedAttributeValue.fromString(input.s()).convert(VISITOR);
            }
            return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class Visitor
    extends TypeConvertingVisitor<MonthDay> {
        private Visitor() {
            super(MonthDay.class, MonthDayAttributeConverter.class);
        }

        @Override
        public MonthDay convertString(String value) {
            return MonthDay.parse(value);
        }
    }
}

