/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.document;

import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkNumber;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.document.DefaultEnhancedDocument;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public interface EnhancedDocument {
    public static EnhancedDocument fromJson(String json) {
        Validate.paramNotNull((Object)json, (String)"json");
        return DefaultEnhancedDocument.builder().json(json).attributeConverterProviders(AttributeConverterProvider.defaultProvider()).build();
    }

    public static EnhancedDocument fromAttributeValueMap(Map<String, AttributeValue> attributeValueMap) {
        Validate.paramNotNull(attributeValueMap, (String)"attributeValueMap");
        return DefaultEnhancedDocument.builder().attributeValueMap(attributeValueMap).attributeConverterProviders(AttributeConverterProvider.defaultProvider()).build();
    }

    public static Builder builder() {
        return DefaultEnhancedDocument.builder();
    }

    public Builder toBuilder();

    public boolean isNull(String var1);

    public boolean isPresent(String var1);

    public <T> T get(String var1, EnhancedType<T> var2);

    public <T> T get(String var1, Class<T> var2);

    public String getString(String var1);

    public SdkNumber getNumber(String var1);

    public SdkBytes getBytes(String var1);

    public Set<String> getStringSet(String var1);

    public Set<SdkNumber> getNumberSet(String var1);

    public Set<SdkBytes> getBytesSet(String var1);

    public <T> List<T> getList(String var1, EnhancedType<T> var2);

    public <K, V> Map<K, V> getMap(String var1, EnhancedType<K> var2, EnhancedType<V> var3);

    public String getJson(String var1);

    public Boolean getBoolean(String var1);

    public List<AttributeValue> getListOfUnknownType(String var1);

    public Map<String, AttributeValue> getMapOfUnknownType(String var1);

    public String toJson();

    public Map<String, AttributeValue> toMap();

    public List<AttributeConverterProvider> attributeConverterProviders();

    @NotThreadSafe
    public static interface Builder {
        public Builder putString(String var1, String var2);

        public Builder putNumber(String var1, Number var2);

        public Builder putBytes(String var1, SdkBytes var2);

        public Builder putBoolean(String var1, boolean var2);

        public Builder putNull(String var1);

        public Builder putStringSet(String var1, Set<String> var2);

        public Builder putNumberSet(String var1, Set<Number> var2);

        public Builder putBytesSet(String var1, Set<SdkBytes> var2);

        public <T> Builder putList(String var1, List<T> var2, EnhancedType<T> var3);

        public <T> Builder put(String var1, T var2, EnhancedType<T> var3);

        public <T> Builder put(String var1, T var2, Class<T> var3);

        public <K, V> Builder putMap(String var1, Map<K, V> var2, EnhancedType<K> var3, EnhancedType<V> var4);

        public Builder putJson(String var1, String var2);

        public Builder remove(String var1);

        public Builder addAttributeConverterProvider(AttributeConverterProvider var1);

        public Builder attributeConverterProviders(List<AttributeConverterProvider> var1);

        public Builder attributeConverterProviders(AttributeConverterProvider ... var1);

        public Builder json(String var1);

        public Builder attributeValueMap(Map<String, AttributeValue> var1);

        public EnhancedDocument build();
    }
}

