/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.extensions.ReadModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.DefaultDynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.model.Page;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;

@SdkInternalApi
public final class EnhancedClientUtils {
    private static final Set<Character> SPECIAL_CHARACTERS = Stream.of(Character.valueOf('*'), Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf(':'), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(' '), Character.valueOf('&'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('%'), Character.valueOf('$'), Character.valueOf('|')).collect(Collectors.toSet());
    private static final Pattern NESTED_OBJECT_PATTERN = Pattern.compile("_NESTED_ATTR_UPDATE_");

    private EnhancedClientUtils() {
    }

    public static String cleanAttributeName(String key) {
        boolean somethingChanged = false;
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!SPECIAL_CHARACTERS.contains(Character.valueOf(chars[i]))) continue;
            chars[i] = 95;
            somethingChanged = true;
        }
        return somethingChanged ? new String(chars) : key;
    }

    private static boolean isNestedAttribute(String key) {
        return key.contains("_NESTED_ATTR_UPDATE_");
    }

    public static String keyRef(String key) {
        String cleanAttributeName = EnhancedClientUtils.cleanAttributeName(key);
        cleanAttributeName = EnhancedClientUtils.isNestedAttribute(cleanAttributeName) ? NESTED_OBJECT_PATTERN.matcher(cleanAttributeName).replaceAll(".#AMZN_MAPPED_") : cleanAttributeName;
        return "#AMZN_MAPPED_" + cleanAttributeName;
    }

    public static String valueRef(String value) {
        String cleanAttributeName = EnhancedClientUtils.cleanAttributeName(value);
        cleanAttributeName = EnhancedClientUtils.isNestedAttribute(cleanAttributeName) ? NESTED_OBJECT_PATTERN.matcher(cleanAttributeName).replaceAll("_") : cleanAttributeName;
        return ":AMZN_MAPPED_" + cleanAttributeName;
    }

    public static <T> T readAndTransformSingleItem(Map<String, AttributeValue> itemMap, TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
        ReadModification readModification;
        if (itemMap == null || itemMap.isEmpty()) {
            return null;
        }
        if (dynamoDbEnhancedClientExtension != null && (readModification = dynamoDbEnhancedClientExtension.afterRead(DefaultDynamoDbExtensionContext.builder().items(itemMap).tableSchema(tableSchema).operationContext(operationContext).tableMetadata(tableSchema.tableMetadata()).build())) != null && readModification.transformedItem() != null) {
            return tableSchema.mapToItem(readModification.transformedItem());
        }
        return tableSchema.mapToItem(itemMap);
    }

    public static <ResponseT, ItemT> Page<ItemT> readAndTransformPaginatedItems(ResponseT response, TableSchema<ItemT> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension, Function<ResponseT, List<Map<String, AttributeValue>>> getItems, Function<ResponseT, Map<String, AttributeValue>> getLastEvaluatedKey, Function<ResponseT, Integer> count, Function<ResponseT, Integer> scannedCount, Function<ResponseT, ConsumedCapacity> consumedCapacity) {
        List collect = getItems.apply(response).stream().map(itemMap -> EnhancedClientUtils.readAndTransformSingleItem(itemMap, tableSchema, operationContext, dynamoDbEnhancedClientExtension)).collect(Collectors.toList());
        Page.Builder<ItemT> pageBuilder = Page.builder(tableSchema.itemType().rawClass()).items(collect).count(count.apply(response)).scannedCount(scannedCount.apply(response)).consumedCapacity(consumedCapacity.apply(response));
        if (getLastEvaluatedKey.apply(response) != null && !getLastEvaluatedKey.apply(response).isEmpty()) {
            pageBuilder.lastEvaluatedKey(getLastEvaluatedKey.apply(response));
        }
        return pageBuilder.build();
    }

    public static <T> Key createKeyFromItem(T item, TableSchema<T> tableSchema, String indexName) {
        String partitionKeyName = tableSchema.tableMetadata().indexPartitionKey(indexName);
        Optional<String> sortKeyName = tableSchema.tableMetadata().indexSortKey(indexName);
        AttributeValue partitionKeyValue = tableSchema.attributeValue(item, partitionKeyName);
        Optional<AttributeValue> sortKeyValue = sortKeyName.map(key -> tableSchema.attributeValue(item, (String)key));
        return sortKeyValue.map(attributeValue -> Key.builder().partitionValue(partitionKeyValue).sortValue((AttributeValue)attributeValue).build()).orElseGet(() -> Key.builder().partitionValue(partitionKeyValue).build());
    }

    public static Key createKeyFromMap(Map<String, AttributeValue> itemMap, TableSchema<?> tableSchema, String indexName) {
        String partitionKeyName = tableSchema.tableMetadata().indexPartitionKey(indexName);
        Optional<String> sortKeyName = tableSchema.tableMetadata().indexSortKey(indexName);
        AttributeValue partitionKeyValue = itemMap.get(partitionKeyName);
        Optional<AttributeValue> sortKeyValue = sortKeyName.map(itemMap::get);
        return sortKeyValue.map(attributeValue -> Key.builder().partitionValue(partitionKeyValue).sortValue((AttributeValue)attributeValue).build()).orElseGet(() -> Key.builder().partitionValue(partitionKeyValue).build());
    }

    public static <T> List<T> getItemsFromSupplier(List<Supplier<T>> itemSupplierList) {
        if (itemSupplierList == null || itemSupplierList.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(itemSupplierList.stream().map(Supplier::get).collect(Collectors.toList()));
    }

    public static boolean isNullAttributeValue(AttributeValue attributeValue) {
        return attributeValue.nul() != null && attributeValue.nul() != false;
    }
}

