/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the auto scaling configuration for a global table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableAutoScalingDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TableAutoScalingDescription.Builder, TableAutoScalingDescription> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableAutoScalingDescription::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableAutoScalingDescription::tableStatusAsString)).setter(setter(Builder::tableStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()).build();

    private static final SdkField<List<ReplicaAutoScalingDescription>> REPLICAS_FIELD = SdkField
            .<List<ReplicaAutoScalingDescription>> builder(MarshallingType.LIST)
            .getter(getter(TableAutoScalingDescription::replicas))
            .setter(setter(Builder::replicas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replicas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaAutoScalingDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaAutoScalingDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            TABLE_STATUS_FIELD, REPLICAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableName;

    private final String tableStatus;

    private final List<ReplicaAutoScalingDescription> replicas;

    private TableAutoScalingDescription(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.tableStatus = builder.tableStatus;
        this.replicas = builder.replicas;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The current state of the table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The table is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The table is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The table is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableStatus} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableStatusAsString}.
     * </p>
     * 
     * @return The current state of the table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The table is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The table is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The table is ready for use.
     *         </p>
     *         </li>
     * @see TableStatus
     */
    public TableStatus tableStatus() {
        return TableStatus.fromValue(tableStatus);
    }

    /**
     * <p>
     * The current state of the table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The table is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The table is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The table is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableStatus} will
     * return {@link TableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableStatusAsString}.
     * </p>
     * 
     * @return The current state of the table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The table is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The table is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The table is ready for use.
     *         </p>
     *         </li>
     * @see TableStatus
     */
    public String tableStatusAsString() {
        return tableStatus;
    }

    /**
     * Returns true if the Replicas property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReplicas() {
        return replicas != null && !(replicas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents replicas of the global table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicas()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents replicas of the global table.
     */
    public List<ReplicaAutoScalingDescription> replicas() {
        return replicas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicas());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableAutoScalingDescription)) {
            return false;
        }
        TableAutoScalingDescription other = (TableAutoScalingDescription) obj;
        return Objects.equals(tableName(), other.tableName())
                && Objects.equals(tableStatusAsString(), other.tableStatusAsString())
                && Objects.equals(replicas(), other.replicas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TableAutoScalingDescription").add("TableName", tableName())
                .add("TableStatus", tableStatusAsString()).add("Replicas", replicas()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TableStatus":
            return Optional.ofNullable(clazz.cast(tableStatusAsString()));
        case "Replicas":
            return Optional.ofNullable(clazz.cast(replicas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableAutoScalingDescription, T> g) {
        return obj -> g.apply((TableAutoScalingDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableAutoScalingDescription> {
        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The current state of the table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The table is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The table is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The table is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tableStatus
         *        The current state of the table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The table is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The table is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The table is ready for use.
         *        </p>
         *        </li>
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder tableStatus(String tableStatus);

        /**
         * <p>
         * The current state of the table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The table is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The table is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The table is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tableStatus
         *        The current state of the table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The table is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The table is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The table is ready for use.
         *        </p>
         *        </li>
         * @see TableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableStatus
         */
        Builder tableStatus(TableStatus tableStatus);

        /**
         * <p>
         * Represents replicas of the global table.
         * </p>
         * 
         * @param replicas
         *        Represents replicas of the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(Collection<ReplicaAutoScalingDescription> replicas);

        /**
         * <p>
         * Represents replicas of the global table.
         * </p>
         * 
         * @param replicas
         *        Represents replicas of the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(ReplicaAutoScalingDescription... replicas);

        /**
         * <p>
         * Represents replicas of the global table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaAutoScalingDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ReplicaAutoScalingDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaAutoScalingDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicas(List<ReplicaAutoScalingDescription>)}.
         * 
         * @param replicas
         *        a consumer that will call methods on {@link List<ReplicaAutoScalingDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicas(List<ReplicaAutoScalingDescription>)
         */
        Builder replicas(Consumer<ReplicaAutoScalingDescription.Builder>... replicas);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private String tableStatus;

        private List<ReplicaAutoScalingDescription> replicas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableAutoScalingDescription model) {
            tableName(model.tableName);
            tableStatus(model.tableStatus);
            replicas(model.replicas);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getTableStatusAsString() {
            return tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus == null ? null : tableStatus.toString());
            return this;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        public final Collection<ReplicaAutoScalingDescription.Builder> getReplicas() {
            return replicas != null ? replicas.stream().map(ReplicaAutoScalingDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicas(Collection<ReplicaAutoScalingDescription> replicas) {
            this.replicas = ReplicaAutoScalingDescriptionListCopier.copy(replicas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(ReplicaAutoScalingDescription... replicas) {
            replicas(Arrays.asList(replicas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(Consumer<ReplicaAutoScalingDescription.Builder>... replicas) {
            replicas(Stream.of(replicas).map(c -> ReplicaAutoScalingDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicas(Collection<ReplicaAutoScalingDescription.BuilderImpl> replicas) {
            this.replicas = ReplicaAutoScalingDescriptionListCopier.copyFromBuilder(replicas);
        }

        @Override
        public TableAutoScalingDescription build() {
            return new TableAutoScalingDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
