/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTableRequest extends DynamoDbRequest implements
        ToCopyableBuilder<CreateTableRequest.Builder, CreateTableRequest> {
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<AttributeDefinition>> builder(MarshallingType.LIST)
            .getter(getter(CreateTableRequest::attributeDefinitions))
            .setter(setter(Builder::attributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTableRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .getter(getter(CreateTableRequest::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<LocalSecondaryIndex>> builder(MarshallingType.LIST)
            .getter(getter(CreateTableRequest::localSecondaryIndexes))
            .setter(setter(Builder::localSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<GlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .getter(getter(CreateTableRequest::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTableRequest::billingModeAsString)).setter(setter(Builder::billingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).getter(getter(CreateTableRequest::provisionedThroughput))
            .setter(setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<StreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField
            .<StreamSpecification> builder(MarshallingType.SDK_POJO).getter(getter(CreateTableRequest::streamSpecification))
            .setter(setter(Builder::streamSpecification)).constructor(StreamSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build())
            .build();

    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField
            .<SSESpecification> builder(MarshallingType.SDK_POJO).getter(getter(CreateTableRequest::sseSpecification))
            .setter(setter(Builder::sseSpecification)).constructor(SSESpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateTableRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD,
            TABLE_NAME_FIELD, KEY_SCHEMA_FIELD, LOCAL_SECONDARY_INDEXES_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD,
            BILLING_MODE_FIELD, PROVISIONED_THROUGHPUT_FIELD, STREAM_SPECIFICATION_FIELD, SSE_SPECIFICATION_FIELD, TAGS_FIELD));

    private final List<AttributeDefinition> attributeDefinitions;

    private final String tableName;

    private final List<KeySchemaElement> keySchema;

    private final List<LocalSecondaryIndex> localSecondaryIndexes;

    private final List<GlobalSecondaryIndex> globalSecondaryIndexes;

    private final String billingMode;

    private final ProvisionedThroughput provisionedThroughput;

    private final StreamSpecification streamSpecification;

    private final SSESpecification sseSpecification;

    private final List<Tag> tags;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.billingMode = builder.billingMode;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.streamSpecification = builder.streamSpecification;
        this.sseSpecification = builder.sseSpecification;
        this.tags = builder.tags;
    }

    /**
     * Returns true if the AttributeDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttributeDefinitions() {
        return attributeDefinitions != null && !(attributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of attributes that describe the key schema for the table and indexes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributeDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of attributes that describe the key schema for the table and indexes.
     */
    public List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * The name of the table to create.
     * </p>
     * 
     * @return The name of the table to create.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * Returns true if the KeySchema property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the attributes that make up the primary key for a table or an index. The attributes in
     * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more information,
     * see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Each <code>KeySchemaElement</code> in the array is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AttributeName</code> - The name of this key attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KeyType</code> - The role that the key attribute will assume:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HASH</code> - partition key
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RANGE</code> - sort key
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from
     * the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their
     * partition key values.
     * </p>
     * <p>
     * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the
     * way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key
     * value.
     * </p>
     * </note>
     * <p>
     * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
     * <code>HASH</code>.
     * </p>
     * <p>
     * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order:
     * The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must have a
     * <code>KeyType</code> of <code>RANGE</code>.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
     * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeySchema()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the attributes that make up the primary key for a table or an index. The attributes in
     *         <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in
     *         the <i>Amazon DynamoDB Developer Guide</i>.</p>
     *         <p>
     *         Each <code>KeySchemaElement</code> in the array is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AttributeName</code> - The name of this key attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KeyType</code> - The role that the key attribute will assume:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HASH</code> - partition key
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RANGE</code> - sort key
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
     *         derives from the DynamoDB usage of an internal hash function to evenly distribute data items across
     *         partitions, based on their partition key values.
     *         </p>
     *         <p>
     *         The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives
     *         from the way DynamoDB stores items with the same partition key physically close together, in sorted order
     *         by the sort key value.
     *         </p>
     *         </note>
     *         <p>
     *         For a simple primary key (partition key), you must provide exactly one element with a
     *         <code>KeyType</code> of <code>HASH</code>.
     *         </p>
     *         <p>
     *         For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
     *         order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element
     *         must have a <code>KeyType</code> of <code>RANGE</code>.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
     *         >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * Returns true if the LocalSecondaryIndexes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLocalSecondaryIndexes() {
        return localSecondaryIndexes != null && !(localSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
     * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local
     * secondary index is unconstrained.
     * </p>
     * <p>
     * Each local secondary index in the array includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with
     * the same partition key as the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected
     * attributes is in <code>NonKeyAttributes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocalSecondaryIndexes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped
     *         to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size
     *         of a local secondary index is unconstrained.</p>
     *         <p>
     *         Each local secondary index in the array includes the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
     *         </p>
     *         <p/></li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
     *         begin with the same partition key as the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
     *         projected attributes is in <code>NonKeyAttributes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 100. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public List<LocalSecondaryIndex> localSecondaryIndexes() {
        return localSecondaryIndexes;
    }

    /**
     * Returns true if the GlobalSecondaryIndexes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index
     * in the array includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
     * </p>
     * <p/></li>
     * <li>
     * <p>
     * <code>KeySchema</code> - Specifies the key schema for the global secondary index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These
     * are in addition to the primary key attributes and index key attributes, which are automatically projected. Each
     * attribute specification is composed of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProjectionType</code> - One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected
     * attributes is in <code>NonKeyAttributes</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All of the table attributes are projected into the index.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of
     * the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this
     * counts as two distinct attributes when determining the total.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     * consisting of read and write capacity units.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalSecondaryIndexes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more global secondary indexes (the maximum is 20) to be created on the table. Each global
     *         secondary index in the array includes the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
     *         </p>
     *         <p/></li>
     *         <li>
     *         <p>
     *         <code>KeySchema</code> - Specifies the key schema for the global secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
     *         These are in addition to the primary key attributes and index key attributes, which are automatically
     *         projected. Each attribute specification is composed of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProjectionType</code> - One of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
     *         projected attributes is in <code>NonKeyAttributes</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All of the table attributes are projected into the index.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
     *         secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across
     *         all of the secondary indexes, must not exceed 100. If you project the same attribute into two different
     *         indexes, this counts as two distinct attributes when determining the total.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
     *         consisting of read and write capacity units.
     *         </p>
     *         </li>
     */
    public List<GlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     * <code>PROVISIONED</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     * >Provisioned Mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     * >On-Demand Mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     *         <code>PROVISIONED</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     *         >Provisioned Mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     *         >On-Demand Mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public BillingMode billingMode() {
        return BillingMode.fromValue(billingMode);
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
     * changed later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     * <code>PROVISIONED</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     * >Provisioned Mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     * >On-Demand Mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. This setting can
     *         be changed later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     *         <code>PROVISIONED</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     *         >Provisioned Mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     *         >On-Demand Mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public String billingModeAsString() {
        return billingMode;
    }

    /**
     * <p>
     * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using
     * the <code>UpdateTable</code> operation.
     * </p>
     * <p>
     * If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as
     * <code>PAY_PER_REQUEST</code>, you cannot specify this property.
     * </p>
     * <p>
     * For current minimum and maximum provisioned throughput values, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the <i>Amazon
     * DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return Represents the provisioned throughput settings for a specified table or index. The settings can be
     *         modified using the <code>UpdateTable</code> operation.</p>
     *         <p>
     *         If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set
     *         BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.
     *         </p>
     *         <p>
     *         For current minimum and maximum provisioned throughput values, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
     *         <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * The settings for DynamoDB Streams on the table. These settings consist of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines what
     * information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The settings for DynamoDB Streams on the table. These settings consist of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled
     *         (false).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
     *         determines what information is written to the table's stream. Valid values for
     *         <code>StreamViewType</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
     *         stream.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public StreamSpecification streamSpecification() {
        return streamSpecification;
    }

    /**
     * <p>
     * Represents the settings used to enable server-side encryption.
     * </p>
     * 
     * @return Represents the settings used to enable server-side encryption.
     */
    public SSESpecification sseSpecification() {
        return sseSpecification;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to label the table. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs to label the table. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
     *         DynamoDB</a>.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(localSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(globalSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest) obj;
        return Objects.equals(attributeDefinitions(), other.attributeDefinitions())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(keySchema(), other.keySchema())
                && Objects.equals(localSecondaryIndexes(), other.localSecondaryIndexes())
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(billingModeAsString(), other.billingModeAsString())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(streamSpecification(), other.streamSpecification())
                && Objects.equals(sseSpecification(), other.sseSpecification()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTableRequest").add("AttributeDefinitions", attributeDefinitions())
                .add("TableName", tableName()).add("KeySchema", keySchema())
                .add("LocalSecondaryIndexes", localSecondaryIndexes()).add("GlobalSecondaryIndexes", globalSecondaryIndexes())
                .add("BillingMode", billingModeAsString()).add("ProvisionedThroughput", provisionedThroughput())
                .add("StreamSpecification", streamSpecification()).add("SSESpecification", sseSpecification())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeDefinitions":
            return Optional.ofNullable(clazz.cast(attributeDefinitions()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "LocalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(localSecondaryIndexes()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "BillingMode":
            return Optional.ofNullable(clazz.cast(billingModeAsString()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "StreamSpecification":
            return Optional.ofNullable(clazz.cast(streamSpecification()));
        case "SSESpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTableRequest> {
        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeDefinition>.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeDefinitions(List<AttributeDefinition>)}.
         * 
         * @param attributeDefinitions
         *        a consumer that will call methods on {@link List<AttributeDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinitions(List<AttributeDefinition>)
         */
        Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions);

        /**
         * <p>
         * The name of the table to create.
         * </p>
         * 
         * @param tableName
         *        The name of the table to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        Specifies the attributes that make up the primary key for a table or an index. The attributes in
         *        <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a>
         *        in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        Each <code>KeySchemaElement</code> in the array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of this key attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role that the key attribute will assume:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from the DynamoDB usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note>
         *        <p>
         *        For a simple primary key (partition key), you must provide exactly one element with a
         *        <code>KeyType</code> of <code>HASH</code>.
         *        </p>
         *        <p>
         *        For a composite primary key (partition key and sort key), you must provide exactly two elements, in
         *        this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second
         *        element must have a <code>KeyType</code> of <code>RANGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         *        >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keySchema
         *        Specifies the attributes that make up the primary key for a table or an index. The attributes in
         *        <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a>
         *        in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        Each <code>KeySchemaElement</code> in the array is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AttributeName</code> - The name of this key attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KeyType</code> - The role that the key attribute will assume:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HASH</code> - partition key
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RANGE</code> - sort key
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute"
         *        derives from the DynamoDB usage of an internal hash function to evenly distribute data items across
         *        partitions, based on their partition key values.
         *        </p>
         *        <p>
         *        The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute"
         *        derives from the way DynamoDB stores items with the same partition key physically close together, in
         *        sorted order by the sort key value.
         *        </p>
         *        </note>
         *        <p>
         *        For a simple primary key (partition key), you must provide exactly one element with a
         *        <code>KeyType</code> of <code>HASH</code>.
         *        </p>
         *        <p>
         *        For a composite primary key (partition key and sort key), you must provide exactly two elements, in
         *        this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second
         *        element must have a <code>KeyType</code> of <code>RANGE</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         *        >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in
         * <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each <code>KeySchemaElement</code> in the array is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AttributeName</code> - The name of this key attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KeyType</code> - The role that the key attribute will assume:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HASH</code> - partition key
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RANGE</code> - sort key
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives
         * from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based
         * on their partition key values.
         * </p>
         * <p>
         * The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from
         * the way DynamoDB stores items with the same partition key physically close together, in sorted order by the
         * sort key value.
         * </p>
         * </note>
         * <p>
         * For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of
         * <code>HASH</code>.
         * </p>
         * <p>
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this
         * order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must
         * have a <code>KeyType</code> of <code>RANGE</code>.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key"
         * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeySchemaElement>.Builder} avoiding the
         * need to create one manually via {@link List<KeySchemaElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeySchemaElement>.Builder#build()} is called immediately and
         * its result is passed to {@link #keySchema(List<KeySchemaElement>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on {@link List<KeySchemaElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(List<KeySchemaElement>)
         */
        Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
         * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param localSecondaryIndexes
         *        One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is
         *        scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise,
         *        the size of a local secondary index is unconstrained.</p>
         *        <p>
         *        Each local secondary index in the array includes the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
         *        begin with the same partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
         * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param localSecondaryIndexes
         *        One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is
         *        scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise,
         *        the size of a local secondary index is unconstrained.</p>
         *        <p>
         *        Each local secondary index in the array includes the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must
         *        begin with the same partition key as the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(LocalSecondaryIndex... localSecondaryIndexes);

        /**
         * <p>
         * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a
         * given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a
         * local secondary index is unconstrained.
         * </p>
         * <p>
         * Each local secondary index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin
         * with the same partition key as the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<LocalSecondaryIndex>.Builder} avoiding the
         * need to create one manually via {@link List<LocalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocalSecondaryIndex>.Builder#build()} is called immediately
         * and its result is passed to {@link #localSecondaryIndexes(List<LocalSecondaryIndex>)}.
         * 
         * @param localSecondaryIndexes
         *        a consumer that will call methods on {@link List<LocalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSecondaryIndexes(List<LocalSecondaryIndex>)
         */
        Builder localSecondaryIndexes(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalSecondaryIndexes
         *        One or more global secondary indexes (the maximum is 20) to be created on the table. Each global
         *        secondary index in the array includes the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalSecondaryIndexes
         *        One or more global secondary indexes (the maximum is 20) to be created on the table. Each global
         *        secondary index in the array includes the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         *        </p>
         *        <p/></li>
         *        <li>
         *        <p>
         *        <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the
         *        index. These are in addition to the primary key attributes and index key attributes, which are
         *        automatically projected. Each attribute specification is composed of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProjectionType</code> - One of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         *        projected attributes is in <code>NonKeyAttributes</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All of the table attributes are projected into the index.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into
         *        the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed
         *        across all of the secondary indexes, must not exceed 100. If you project the same attribute into two
         *        different indexes, this counts as two distinct attributes when determining the total.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary
         *        index, consisting of read and write capacity units.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary
         * index in the array includes the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.
         * </p>
         * <p/></li>
         * <li>
         * <p>
         * <code>KeySchema</code> - Specifies the key schema for the global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index.
         * These are in addition to the primary key attributes and index key attributes, which are automatically
         * projected. Each attribute specification is composed of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProjectionType</code> - One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of
         * projected attributes is in <code>NonKeyAttributes</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All of the table attributes are projected into the index.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the
         * secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all
         * of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes,
         * this counts as two distinct attributes when determining the total.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index,
         * consisting of read and write capacity units.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<GlobalSecondaryIndex>.Builder} avoiding the
         * need to create one manually via {@link List<GlobalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalSecondaryIndex>.Builder#build()} is called immediately
         * and its result is passed to {@link #globalSecondaryIndexes(List<GlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List<GlobalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<GlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         * <code>PROVISIONED</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         * >Provisioned Mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         * >On-Demand Mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         *        <code>PROVISIONED</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         *        >Provisioned Mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         *        >On-Demand Mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(String billingMode);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be
         * changed later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         * <code>PROVISIONED</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         * >Provisioned Mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         * >On-Demand Mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. This setting
         *        can be changed later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         *        <code>PROVISIONED</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         *        >Provisioned Mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         *        >On-Demand Mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(BillingMode billingMode);

        /**
         * <p>
         * Represents the provisioned throughput settings for a specified table or index. The settings can be modified
         * using the <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as
         * <code>PAY_PER_REQUEST</code>, you cannot specify this property.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param provisionedThroughput
         *        Represents the provisioned throughput settings for a specified table or index. The settings can be
         *        modified using the <code>UpdateTable</code> operation.</p>
         *        <p>
         *        If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set
         *        BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.
         *        </p>
         *        <p>
         *        For current minimum and maximum provisioned throughput values, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         *        <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * Represents the provisioned throughput settings for a specified table or index. The settings can be modified
         * using the <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as
         * <code>PAY_PER_REQUEST</code>, you cannot specify this property.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding the need
         * to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * <p>
         * The settings for DynamoDB Streams on the table. These settings consist of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines
         * what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param streamSpecification
         *        The settings for DynamoDB Streams on the table. These settings consist of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled
         *        (false).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code>
         *        determines what information is written to the table's stream. Valid values for
         *        <code>StreamViewType</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the
         *        stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the
         *        stream.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(StreamSpecification streamSpecification);

        /**
         * <p>
         * The settings for DynamoDB Streams on the table. These settings consist of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines
         * what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link StreamSpecification.Builder} avoiding the need
         * to create one manually via {@link StreamSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #streamSpecification(StreamSpecification)}.
         * 
         * @param streamSpecification
         *        a consumer that will call methods on {@link StreamSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSpecification(StreamSpecification)
         */
        default Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return streamSpecification(StreamSpecification.builder().applyMutation(streamSpecification).build());
        }

        /**
         * <p>
         * Represents the settings used to enable server-side encryption.
         * </p>
         * 
         * @param sseSpecification
         *        Represents the settings used to enable server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(SSESpecification sseSpecification);

        /**
         * <p>
         * Represents the settings used to enable server-side encryption.
         * </p>
         * This is a convenience that creates an instance of the {@link SSESpecification.Builder} avoiding the need to
         * create one manually via {@link SSESpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSESpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #sseSpecification(SSESpecification)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link SSESpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(SSESpecification)
         */
        default Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return sseSpecification(SSESpecification.builder().applyMutation(sseSpecification).build());
        }

        /**
         * <p>
         * A list of key-value pairs to label the table. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         * DynamoDB</a>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the table. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         *        DynamoDB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to label the table. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         * DynamoDB</a>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the table. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         *        DynamoDB</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to label the table. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for
         * DynamoDB</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String tableName;

        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();

        private List<LocalSecondaryIndex> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private List<GlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private String billingMode;

        private ProvisionedThroughput provisionedThroughput;

        private StreamSpecification streamSpecification;

        private SSESpecification sseSpecification;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            attributeDefinitions(model.attributeDefinitions);
            tableName(model.tableName);
            keySchema(model.keySchema);
            localSecondaryIndexes(model.localSecondaryIndexes);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            billingMode(model.billingMode);
            provisionedThroughput(model.provisionedThroughput);
            streamSpecification(model.streamSpecification);
            sseSpecification(model.sseSpecification);
            tags(model.tags);
        }

        public final Collection<AttributeDefinition.Builder> getAttributeDefinitions() {
            return attributeDefinitions != null ? attributeDefinitions.stream().map(AttributeDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions) {
            attributeDefinitions(Stream.of(attributeDefinitions).map(c -> AttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return keySchema != null ? keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> KeySchemaElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Collection<LocalSecondaryIndex.Builder> getLocalSecondaryIndexes() {
            return localSecondaryIndexes != null ? localSecondaryIndexes.stream().map(LocalSecondaryIndex::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndex... localSecondaryIndexes) {
            localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<LocalSecondaryIndex.Builder>... localSecondaryIndexes) {
            localSecondaryIndexes(Stream.of(localSecondaryIndexes)
                    .map(c -> LocalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            return globalSecondaryIndexes != null ? globalSecondaryIndexes.stream().map(GlobalSecondaryIndex::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> GlobalSecondaryIndex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public final String getBillingMode() {
            return billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return streamSpecification != null ? streamSpecification.toBuilder() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        public final SSESpecification.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
