/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the point in time settings applied to the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PointInTimeRecoveryDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PointInTimeRecoveryDescription.Builder, PointInTimeRecoveryDescription> {
    private static final SdkField<String> POINT_IN_TIME_RECOVERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PointInTimeRecoveryDescription::pointInTimeRecoveryStatusAsString))
            .setter(setter(Builder::pointInTimeRecoveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointInTimeRecoveryStatus").build())
            .build();

    private static final SdkField<Instant> EARLIEST_RESTORABLE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PointInTimeRecoveryDescription::earliestRestorableDateTime))
            .setter(setter(Builder::earliestRestorableDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestRestorableDateTime").build())
            .build();

    private static final SdkField<Instant> LATEST_RESTORABLE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(PointInTimeRecoveryDescription::latestRestorableDateTime))
            .setter(setter(Builder::latestRestorableDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POINT_IN_TIME_RECOVERY_STATUS_FIELD, EARLIEST_RESTORABLE_DATE_TIME_FIELD, LATEST_RESTORABLE_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pointInTimeRecoveryStatus;

    private final Instant earliestRestorableDateTime;

    private final Instant latestRestorableDateTime;

    private PointInTimeRecoveryDescription(BuilderImpl builder) {
        this.pointInTimeRecoveryStatus = builder.pointInTimeRecoveryStatus;
        this.earliestRestorableDateTime = builder.earliestRestorableDateTime;
        this.latestRestorableDateTime = builder.latestRestorableDateTime;
    }

    /**
     * <p>
     * The current state of point in time recovery:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLING</code> - Point in time recovery is being enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Point in time recovery is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Point in time recovery is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pointInTimeRecoveryStatus} will return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pointInTimeRecoveryStatusAsString}.
     * </p>
     * 
     * @return The current state of point in time recovery:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLING</code> - Point in time recovery is being enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Point in time recovery is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Point in time recovery is disabled.
     *         </p>
     *         </li>
     * @see PointInTimeRecoveryStatus
     */
    public PointInTimeRecoveryStatus pointInTimeRecoveryStatus() {
        return PointInTimeRecoveryStatus.fromValue(pointInTimeRecoveryStatus);
    }

    /**
     * <p>
     * The current state of point in time recovery:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLING</code> - Point in time recovery is being enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Point in time recovery is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Point in time recovery is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pointInTimeRecoveryStatus} will return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pointInTimeRecoveryStatusAsString}.
     * </p>
     * 
     * @return The current state of point in time recovery:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLING</code> - Point in time recovery is being enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Point in time recovery is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Point in time recovery is disabled.
     *         </p>
     *         </li>
     * @see PointInTimeRecoveryStatus
     */
    public String pointInTimeRecoveryStatusAsString() {
        return pointInTimeRecoveryStatus;
    }

    /**
     * <p>
     * Specifies the earliest point in time you can restore your table to. You can restore your table to any point in
     * time during the last 35 days.
     * </p>
     * 
     * @return Specifies the earliest point in time you can restore your table to. You can restore your table to any
     *         point in time during the last 35 days.
     */
    public Instant earliestRestorableDateTime() {
        return earliestRestorableDateTime;
    }

    /**
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
     * </p>
     * 
     * @return <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
     */
    public Instant latestRestorableDateTime() {
        return latestRestorableDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(earliestRestorableDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestorableDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoveryDescription)) {
            return false;
        }
        PointInTimeRecoveryDescription other = (PointInTimeRecoveryDescription) obj;
        return Objects.equals(pointInTimeRecoveryStatusAsString(), other.pointInTimeRecoveryStatusAsString())
                && Objects.equals(earliestRestorableDateTime(), other.earliestRestorableDateTime())
                && Objects.equals(latestRestorableDateTime(), other.latestRestorableDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PointInTimeRecoveryDescription")
                .add("PointInTimeRecoveryStatus", pointInTimeRecoveryStatusAsString())
                .add("EarliestRestorableDateTime", earliestRestorableDateTime())
                .add("LatestRestorableDateTime", latestRestorableDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PointInTimeRecoveryStatus":
            return Optional.ofNullable(clazz.cast(pointInTimeRecoveryStatusAsString()));
        case "EarliestRestorableDateTime":
            return Optional.ofNullable(clazz.cast(earliestRestorableDateTime()));
        case "LatestRestorableDateTime":
            return Optional.ofNullable(clazz.cast(latestRestorableDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PointInTimeRecoveryDescription, T> g) {
        return obj -> g.apply((PointInTimeRecoveryDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PointInTimeRecoveryDescription> {
        /**
         * <p>
         * The current state of point in time recovery:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Point in time recovery is being enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Point in time recovery is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Point in time recovery is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pointInTimeRecoveryStatus
         *        The current state of point in time recovery:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Point in time recovery is being enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Point in time recovery is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Point in time recovery is disabled.
         *        </p>
         *        </li>
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder pointInTimeRecoveryStatus(String pointInTimeRecoveryStatus);

        /**
         * <p>
         * The current state of point in time recovery:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Point in time recovery is being enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Point in time recovery is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Point in time recovery is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pointInTimeRecoveryStatus
         *        The current state of point in time recovery:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Point in time recovery is being enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Point in time recovery is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Point in time recovery is disabled.
         *        </p>
         *        </li>
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus pointInTimeRecoveryStatus);

        /**
         * <p>
         * Specifies the earliest point in time you can restore your table to. You can restore your table to any point
         * in time during the last 35 days.
         * </p>
         * 
         * @param earliestRestorableDateTime
         *        Specifies the earliest point in time you can restore your table to. You can restore your table to any
         *        point in time during the last 35 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestRestorableDateTime(Instant earliestRestorableDateTime);

        /**
         * <p>
         * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
         * </p>
         * 
         * @param latestRestorableDateTime
         *        <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestorableDateTime(Instant latestRestorableDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String pointInTimeRecoveryStatus;

        private Instant earliestRestorableDateTime;

        private Instant latestRestorableDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoveryDescription model) {
            pointInTimeRecoveryStatus(model.pointInTimeRecoveryStatus);
            earliestRestorableDateTime(model.earliestRestorableDateTime);
            latestRestorableDateTime(model.latestRestorableDateTime);
        }

        public final String getPointInTimeRecoveryStatus() {
            return pointInTimeRecoveryStatus;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
            return this;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus(pointInTimeRecoveryStatus == null ? null : pointInTimeRecoveryStatus.toString());
            return this;
        }

        public final void setPointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
        }

        public final Instant getEarliestRestorableDateTime() {
            return earliestRestorableDateTime;
        }

        @Override
        public final Builder earliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
            return this;
        }

        public final void setEarliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
        }

        public final Instant getLatestRestorableDateTime() {
            return latestRestorableDateTime;
        }

        @Override
        public final Builder latestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
            return this;
        }

        public final void setLatestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
        }

        @Override
        public PointInTimeRecoveryDescription build() {
            return new PointInTimeRecoveryDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
