/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGlobalTableSettingsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, DescribeGlobalTableSettingsResponse> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalTableName").getter(DescribeGlobalTableSettingsResponse.getter(DescribeGlobalTableSettingsResponse::globalTableName)).setter(DescribeGlobalTableSettingsResponse.setter(Builder::globalTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()}).build();
    private static final SdkField<List<ReplicaSettingsDescription>> REPLICA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaSettings").getter(DescribeGlobalTableSettingsResponse.getter(DescribeGlobalTableSettingsResponse::replicaSettings)).setter(DescribeGlobalTableSettingsResponse.setter(Builder::replicaSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD, REPLICA_SETTINGS_FIELD));
    private final String globalTableName;
    private final List<ReplicaSettingsDescription> replicaSettings;

    private DescribeGlobalTableSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.replicaSettings = builder.replicaSettings;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public boolean hasReplicaSettings() {
        return this.replicaSettings != null && !(this.replicaSettings instanceof SdkAutoConstructList);
    }

    public List<ReplicaSettingsDescription> replicaSettings() {
        return this.replicaSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalTableSettingsResponse)) {
            return false;
        }
        DescribeGlobalTableSettingsResponse other = (DescribeGlobalTableSettingsResponse)((Object)obj);
        return Objects.equals(this.globalTableName(), other.globalTableName()) && Objects.equals(this.replicaSettings(), other.replicaSettings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGlobalTableSettingsResponse").add("GlobalTableName", (Object)this.globalTableName()).add("ReplicaSettings", this.replicaSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
            case "ReplicaSettings": {
                return Optional.ofNullable(clazz.cast(this.replicaSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalTableSettingsResponse, T> g) {
        return obj -> g.apply((DescribeGlobalTableSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private String globalTableName;
        private List<ReplicaSettingsDescription> replicaSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalTableSettingsResponse model) {
            super(model);
            this.globalTableName(model.globalTableName);
            this.replicaSettings(model.replicaSettings);
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final Collection<ReplicaSettingsDescription.Builder> getReplicaSettings() {
            return this.replicaSettings != null ? (Collection)this.replicaSettings.stream().map(ReplicaSettingsDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaSettings(Collection<ReplicaSettingsDescription> replicaSettings) {
            this.replicaSettings = ReplicaSettingsDescriptionListCopier.copy(replicaSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettings(ReplicaSettingsDescription ... replicaSettings) {
            this.replicaSettings(Arrays.asList(replicaSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettings(Consumer<ReplicaSettingsDescription.Builder> ... replicaSettings) {
            this.replicaSettings(Stream.of(replicaSettings).map(c -> (ReplicaSettingsDescription)((ReplicaSettingsDescription.Builder)ReplicaSettingsDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaSettings(Collection<ReplicaSettingsDescription.BuilderImpl> replicaSettings) {
            this.replicaSettings = ReplicaSettingsDescriptionListCopier.copyFromBuilder(replicaSettings);
        }

        @Override
        public DescribeGlobalTableSettingsResponse build() {
            return new DescribeGlobalTableSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGlobalTableSettingsResponse> {
        public Builder globalTableName(String var1);

        public Builder replicaSettings(Collection<ReplicaSettingsDescription> var1);

        public Builder replicaSettings(ReplicaSettingsDescription ... var1);

        public Builder replicaSettings(Consumer<ReplicaSettingsDescription.Builder> ... var1);
    }
}

