/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the backup created for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupDetails implements SdkPojo, Serializable, ToCopyableBuilder<BackupDetails.Builder, BackupDetails> {
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupArn").getter(getter(BackupDetails::backupArn)).setter(setter(Builder::backupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()).build();

    private static final SdkField<String> BACKUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupName").getter(getter(BackupDetails::backupName)).setter(setter(Builder::backupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupName").build()).build();

    private static final SdkField<Long> BACKUP_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BackupSizeBytes").getter(getter(BackupDetails::backupSizeBytes))
            .setter(setter(Builder::backupSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeBytes").build()).build();

    private static final SdkField<String> BACKUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupStatus").getter(getter(BackupDetails::backupStatusAsString)).setter(setter(Builder::backupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupStatus").build()).build();

    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupType").getter(getter(BackupDetails::backupTypeAsString)).setter(setter(Builder::backupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()).build();

    private static final SdkField<Instant> BACKUP_CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BackupCreationDateTime").getter(getter(BackupDetails::backupCreationDateTime))
            .setter(setter(Builder::backupCreationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupCreationDateTime").build())
            .build();

    private static final SdkField<Instant> BACKUP_EXPIRY_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BackupExpiryDateTime").getter(getter(BackupDetails::backupExpiryDateTime))
            .setter(setter(Builder::backupExpiryDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupExpiryDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ARN_FIELD,
            BACKUP_NAME_FIELD, BACKUP_SIZE_BYTES_FIELD, BACKUP_STATUS_FIELD, BACKUP_TYPE_FIELD, BACKUP_CREATION_DATE_TIME_FIELD,
            BACKUP_EXPIRY_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupArn;

    private final String backupName;

    private final Long backupSizeBytes;

    private final String backupStatus;

    private final String backupType;

    private final Instant backupCreationDateTime;

    private final Instant backupExpiryDateTime;

    private BackupDetails(BuilderImpl builder) {
        this.backupArn = builder.backupArn;
        this.backupName = builder.backupName;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupStatus = builder.backupStatus;
        this.backupType = builder.backupType;
        this.backupCreationDateTime = builder.backupCreationDateTime;
        this.backupExpiryDateTime = builder.backupExpiryDateTime;
    }

    /**
     * <p>
     * ARN associated with the backup.
     * </p>
     * 
     * @return ARN associated with the backup.
     */
    public final String backupArn() {
        return backupArn;
    }

    /**
     * <p>
     * Name of the requested backup.
     * </p>
     * 
     * @return Name of the requested backup.
     */
    public final String backupName() {
        return backupName;
    }

    /**
     * <p>
     * Size of the backup in bytes.
     * </p>
     * 
     * @return Size of the backup in bytes.
     */
    public final Long backupSizeBytes() {
        return backupSizeBytes;
    }

    /**
     * <p>
     * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupStatus} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStatusAsString}.
     * </p>
     * 
     * @return Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * @see BackupStatus
     */
    public final BackupStatus backupStatus() {
        return BackupStatus.fromValue(backupStatus);
    }

    /**
     * <p>
     * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupStatus} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStatusAsString}.
     * </p>
     * 
     * @return Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * @see BackupStatus
     */
    public final String backupStatusAsString() {
        return backupStatus;
    }

    /**
     * <p>
     * BackupType:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - You create and manage these using the on-demand backup feature.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is
     * automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore
     * the deleted table to the state it was in just before the point of deletion.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return BackupType:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - You create and manage these using the on-demand backup feature.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code>
     *         backup is automatically created and is retained for 35 days (at no additional cost). System backups allow
     *         you to restore the deleted table to the state it was in just before the point of deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
     *         </p>
     *         </li>
     * @see BackupType
     */
    public final BackupType backupType() {
        return BackupType.fromValue(backupType);
    }

    /**
     * <p>
     * BackupType:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - You create and manage these using the on-demand backup feature.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is
     * automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore
     * the deleted table to the state it was in just before the point of deletion.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return BackupType:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - You create and manage these using the on-demand backup feature.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code>
     *         backup is automatically created and is retained for 35 days (at no additional cost). System backups allow
     *         you to restore the deleted table to the state it was in just before the point of deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
     *         </p>
     *         </li>
     * @see BackupType
     */
    public final String backupTypeAsString() {
        return backupType;
    }

    /**
     * <p>
     * Time at which the backup was created. This is the request time of the backup.
     * </p>
     * 
     * @return Time at which the backup was created. This is the request time of the backup.
     */
    public final Instant backupCreationDateTime() {
        return backupCreationDateTime;
    }

    /**
     * <p>
     * Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand
     * backup expires automatically 35 days after its creation.
     * </p>
     * 
     * @return Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code>
     *         on-demand backup expires automatically 35 days after its creation.
     */
    public final Instant backupExpiryDateTime() {
        return backupExpiryDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(backupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(backupExpiryDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupDetails)) {
            return false;
        }
        BackupDetails other = (BackupDetails) obj;
        return Objects.equals(backupArn(), other.backupArn()) && Objects.equals(backupName(), other.backupName())
                && Objects.equals(backupSizeBytes(), other.backupSizeBytes())
                && Objects.equals(backupStatusAsString(), other.backupStatusAsString())
                && Objects.equals(backupTypeAsString(), other.backupTypeAsString())
                && Objects.equals(backupCreationDateTime(), other.backupCreationDateTime())
                && Objects.equals(backupExpiryDateTime(), other.backupExpiryDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackupDetails").add("BackupArn", backupArn()).add("BackupName", backupName())
                .add("BackupSizeBytes", backupSizeBytes()).add("BackupStatus", backupStatusAsString())
                .add("BackupType", backupTypeAsString()).add("BackupCreationDateTime", backupCreationDateTime())
                .add("BackupExpiryDateTime", backupExpiryDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupArn":
            return Optional.ofNullable(clazz.cast(backupArn()));
        case "BackupName":
            return Optional.ofNullable(clazz.cast(backupName()));
        case "BackupSizeBytes":
            return Optional.ofNullable(clazz.cast(backupSizeBytes()));
        case "BackupStatus":
            return Optional.ofNullable(clazz.cast(backupStatusAsString()));
        case "BackupType":
            return Optional.ofNullable(clazz.cast(backupTypeAsString()));
        case "BackupCreationDateTime":
            return Optional.ofNullable(clazz.cast(backupCreationDateTime()));
        case "BackupExpiryDateTime":
            return Optional.ofNullable(clazz.cast(backupExpiryDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupDetails, T> g) {
        return obj -> g.apply((BackupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupDetails> {
        /**
         * <p>
         * ARN associated with the backup.
         * </p>
         * 
         * @param backupArn
         *        ARN associated with the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupArn(String backupArn);

        /**
         * <p>
         * Name of the requested backup.
         * </p>
         * 
         * @param backupName
         *        Name of the requested backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupName(String backupName);

        /**
         * <p>
         * Size of the backup in bytes.
         * </p>
         * 
         * @param backupSizeBytes
         *        Size of the backup in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeBytes(Long backupSizeBytes);

        /**
         * <p>
         * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * </p>
         * 
         * @param backupStatus
         *        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder backupStatus(String backupStatus);

        /**
         * <p>
         * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * </p>
         * 
         * @param backupStatus
         *        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder backupStatus(BackupStatus backupStatus);

        /**
         * <p>
         * BackupType:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - You create and manage these using the on-demand backup feature.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup
         * is automatically created and is retained for 35 days (at no additional cost). System backups allow you to
         * restore the deleted table to the state it was in just before the point of deletion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupType
         *        BackupType:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - You create and manage these using the on-demand backup feature.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code>
         *        backup is automatically created and is retained for 35 days (at no additional cost). System backups
         *        allow you to restore the deleted table to the state it was in just before the point of deletion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
         *        </p>
         *        </li>
         * @see BackupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupType
         */
        Builder backupType(String backupType);

        /**
         * <p>
         * BackupType:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - You create and manage these using the on-demand backup feature.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup
         * is automatically created and is retained for 35 days (at no additional cost). System backups allow you to
         * restore the deleted table to the state it was in just before the point of deletion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupType
         *        BackupType:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - You create and manage these using the on-demand backup feature.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code>
         *        backup is automatically created and is retained for 35 days (at no additional cost). System backups
         *        allow you to restore the deleted table to the state it was in just before the point of deletion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_BACKUP</code> - On-demand backup created by you from AWS Backup service.
         *        </p>
         *        </li>
         * @see BackupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupType
         */
        Builder backupType(BackupType backupType);

        /**
         * <p>
         * Time at which the backup was created. This is the request time of the backup.
         * </p>
         * 
         * @param backupCreationDateTime
         *        Time at which the backup was created. This is the request time of the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupCreationDateTime(Instant backupCreationDateTime);

        /**
         * <p>
         * Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code>
         * on-demand backup expires automatically 35 days after its creation.
         * </p>
         * 
         * @param backupExpiryDateTime
         *        Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code>
         *        on-demand backup expires automatically 35 days after its creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupExpiryDateTime(Instant backupExpiryDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String backupArn;

        private String backupName;

        private Long backupSizeBytes;

        private String backupStatus;

        private String backupType;

        private Instant backupCreationDateTime;

        private Instant backupExpiryDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupDetails model) {
            backupArn(model.backupArn);
            backupName(model.backupName);
            backupSizeBytes(model.backupSizeBytes);
            backupStatus(model.backupStatus);
            backupType(model.backupType);
            backupCreationDateTime(model.backupCreationDateTime);
            backupExpiryDateTime(model.backupExpiryDateTime);
        }

        public final String getBackupArn() {
            return backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupName() {
            return backupName;
        }

        @Override
        public final Builder backupName(String backupName) {
            this.backupName = backupName;
            return this;
        }

        public final void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public final Long getBackupSizeBytes() {
            return backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        public final String getBackupStatus() {
            return backupStatus;
        }

        @Override
        public final Builder backupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
            return this;
        }

        @Override
        public final Builder backupStatus(BackupStatus backupStatus) {
            this.backupStatus(backupStatus == null ? null : backupStatus.toString());
            return this;
        }

        public final void setBackupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
        }

        public final String getBackupType() {
            return backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupType backupType) {
            this.backupType(backupType == null ? null : backupType.toString());
            return this;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        public final Instant getBackupCreationDateTime() {
            return backupCreationDateTime;
        }

        @Override
        public final Builder backupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
            return this;
        }

        public final void setBackupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
        }

        public final Instant getBackupExpiryDateTime() {
            return backupExpiryDateTime;
        }

        @Override
        public final Builder backupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
            return this;
        }

        public final void setBackupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
        }

        @Override
        public BackupDetails build() {
            return new BackupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
