/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.BatchGetResponseMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetItemResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, BatchGetItemResponse> {
    private static final SdkField<Map<String, List<Map<String, AttributeValue>>>> RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Responses").getter(BatchGetItemResponse.getter(BatchGetItemResponse::responses)).setter(BatchGetItemResponse.setter(Builder::responses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, KeysAndAttributes>> UNPROCESSED_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UnprocessedKeys").getter(BatchGetItemResponse.getter(BatchGetItemResponse::unprocessedKeys)).setter(BatchGetItemResponse.setter(Builder::unprocessedKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedKeys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeysAndAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumedCapacity").getter(BatchGetItemResponse.getter(BatchGetItemResponse::consumedCapacity)).setter(BatchGetItemResponse.setter(Builder::consumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD, UNPROCESSED_KEYS_FIELD, CONSUMED_CAPACITY_FIELD));
    private final Map<String, List<Map<String, AttributeValue>>> responses;
    private final Map<String, KeysAndAttributes> unprocessedKeys;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchGetItemResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
        this.unprocessedKeys = builder.unprocessedKeys;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public final boolean hasResponses() {
        return this.responses != null && !(this.responses instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<Map<String, AttributeValue>>> responses() {
        return this.responses;
    }

    public final boolean hasUnprocessedKeys() {
        return this.unprocessedKeys != null && !(this.unprocessedKeys instanceof SdkAutoConstructMap);
    }

    public final Map<String, KeysAndAttributes> unprocessedKeys() {
        return this.unprocessedKeys;
    }

    public final boolean hasConsumedCapacity() {
        return this.consumedCapacity != null && !(this.consumedCapacity instanceof SdkAutoConstructList);
    }

    public final List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponses() ? this.responses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedKeys() ? this.unprocessedKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumedCapacity() ? this.consumedCapacity() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResponse)) {
            return false;
        }
        BatchGetItemResponse other = (BatchGetItemResponse)((Object)obj);
        return this.hasResponses() == other.hasResponses() && Objects.equals(this.responses(), other.responses()) && this.hasUnprocessedKeys() == other.hasUnprocessedKeys() && Objects.equals(this.unprocessedKeys(), other.unprocessedKeys()) && this.hasConsumedCapacity() == other.hasConsumedCapacity() && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetItemResponse").add("Responses", this.hasResponses() ? this.responses() : null).add("UnprocessedKeys", this.hasUnprocessedKeys() ? this.unprocessedKeys() : null).add("ConsumedCapacity", this.hasConsumedCapacity() ? this.consumedCapacity() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Responses": {
                return Optional.ofNullable(clazz.cast(this.responses()));
            }
            case "UnprocessedKeys": {
                return Optional.ofNullable(clazz.cast(this.unprocessedKeys()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetItemResponse, T> g) {
        return obj -> g.apply((BatchGetItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private Map<String, List<Map<String, AttributeValue>>> responses = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, KeysAndAttributes> unprocessedKeys = DefaultSdkAutoConstructMap.getInstance();
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemResponse model) {
            super(model);
            this.responses(model.responses);
            this.unprocessedKeys(model.unprocessedKeys);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, List<Map<String, AttributeValue.Builder>>> getResponses() {
            Map<String, List<Map<String, AttributeValue.Builder>>> result = BatchGetResponseMapCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder responses(Map<String, ? extends Collection<? extends Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
            return this;
        }

        public final void setResponses(Map<String, ? extends Collection<? extends Map<String, AttributeValue.BuilderImpl>>> responses) {
            this.responses = BatchGetResponseMapCopier.copyFromBuilder(responses);
        }

        public final Map<String, KeysAndAttributes.Builder> getUnprocessedKeys() {
            Map<String, KeysAndAttributes.Builder> result = BatchGetRequestMapCopier.copyToBuilder(this.unprocessedKeys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder unprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copy(unprocessedKeys);
            return this;
        }

        public final void setUnprocessedKeys(Map<String, KeysAndAttributes.BuilderImpl> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copyFromBuilder(unprocessedKeys);
        }

        public final List<ConsumedCapacity.Builder> getConsumedCapacity() {
            List<ConsumedCapacity.Builder> result = ConsumedCapacityMultipleCopier.copyToBuilder(this.consumedCapacity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... consumedCapacity) {
            this.consumedCapacity(Stream.of(consumedCapacity).map(c -> (ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        @Override
        public BatchGetItemResponse build() {
            return new BatchGetItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetItemResponse> {
        public Builder responses(Map<String, ? extends Collection<? extends Map<String, AttributeValue>>> var1);

        public Builder unprocessedKeys(Map<String, KeysAndAttributes> var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);

        public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... var1);
    }
}

