/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.PreparedStatementParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteStatementRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ExecuteStatementRequest> {
    private static final SdkField<String> STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statement").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::statement)).setter(ExecuteStatementRequest.setter(Builder::statement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()}).build();
    private static final SdkField<List<AttributeValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::parameters)).setter(ExecuteStatementRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConsistentRead").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::consistentRead)).setter(ExecuteStatementRequest.setter(Builder::consistentRead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::nextToken)).setter(ExecuteStatementRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_FIELD, PARAMETERS_FIELD, CONSISTENT_READ_FIELD, NEXT_TOKEN_FIELD));
    private final String statement;
    private final List<AttributeValue> parameters;
    private final Boolean consistentRead;
    private final String nextToken;

    private ExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.statement = builder.statement;
        this.parameters = builder.parameters;
        this.consistentRead = builder.consistentRead;
        this.nextToken = builder.nextToken;
    }

    public final String statement() {
        return this.statement;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<AttributeValue> parameters() {
        return this.parameters;
    }

    public final Boolean consistentRead() {
        return this.consistentRead;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statement());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest)((Object)obj);
        return Objects.equals(this.statement(), other.statement()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.consistentRead(), other.consistentRead()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteStatementRequest").add("Statement", (Object)this.statement()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ConsistentRead", (Object)this.consistentRead()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statement": {
                return Optional.ofNullable(clazz.cast(this.statement()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ConsistentRead": {
                return Optional.ofNullable(clazz.cast(this.consistentRead()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String statement;
        private List<AttributeValue> parameters = DefaultSdkAutoConstructList.getInstance();
        private Boolean consistentRead;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            super(model);
            this.statement(model.statement);
            this.parameters(model.parameters);
            this.consistentRead(model.consistentRead);
            this.nextToken(model.nextToken);
        }

        public final String getStatement() {
            return this.statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        public final List<AttributeValue.Builder> getParameters() {
            List<AttributeValue.Builder> result = PreparedStatementParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameters(Collection<AttributeValue> parameters) {
            this.parameters = PreparedStatementParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(AttributeValue ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<AttributeValue.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<AttributeValue.BuilderImpl> parameters) {
            this.parameters = PreparedStatementParametersCopier.copyFromBuilder(parameters);
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteStatementRequest> {
        public Builder statement(String var1);

        public Builder parameters(Collection<AttributeValue> var1);

        public Builder parameters(AttributeValue ... var1);

        public Builder parameters(Consumer<AttributeValue.Builder> ... var1);

        public Builder consistentRead(Boolean var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

