/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecs.model.Scope;
import software.amazon.awssdk.services.ecs.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DockerVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DockerVolumeConfiguration> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(DockerVolumeConfiguration.getter(DockerVolumeConfiguration::scopeAsString)).setter(DockerVolumeConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<Boolean> AUTOPROVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoprovision").getter(DockerVolumeConfiguration.getter(DockerVolumeConfiguration::autoprovision)).setter(DockerVolumeConfiguration.setter(Builder::autoprovision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoprovision").build()}).build();
    private static final SdkField<String> DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("driver").getter(DockerVolumeConfiguration.getter(DockerVolumeConfiguration::driver)).setter(DockerVolumeConfiguration.setter(Builder::driver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driver").build()}).build();
    private static final SdkField<Map<String, String>> DRIVER_OPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("driverOpts").getter(DockerVolumeConfiguration.getter(DockerVolumeConfiguration::driverOpts)).setter(DockerVolumeConfiguration.setter(Builder::driverOpts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driverOpts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("labels").getter(DockerVolumeConfiguration.getter(DockerVolumeConfiguration::labels)).setter(DockerVolumeConfiguration.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, AUTOPROVISION_FIELD, DRIVER_FIELD, DRIVER_OPTS_FIELD, LABELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final Boolean autoprovision;
    private final String driver;
    private final Map<String, String> driverOpts;
    private final Map<String, String> labels;

    private DockerVolumeConfiguration(BuilderImpl builder) {
        this.scope = builder.scope;
        this.autoprovision = builder.autoprovision;
        this.driver = builder.driver;
        this.driverOpts = builder.driverOpts;
        this.labels = builder.labels;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final Boolean autoprovision() {
        return this.autoprovision;
    }

    public final String driver() {
        return this.driver;
    }

    public final boolean hasDriverOpts() {
        return this.driverOpts != null && !(this.driverOpts instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> driverOpts() {
        return this.driverOpts;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoprovision());
        hashCode = 31 * hashCode + Objects.hashCode(this.driver());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDriverOpts() ? this.driverOpts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DockerVolumeConfiguration)) {
            return false;
        }
        DockerVolumeConfiguration other = (DockerVolumeConfiguration)obj;
        return Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.autoprovision(), other.autoprovision()) && Objects.equals(this.driver(), other.driver()) && this.hasDriverOpts() == other.hasDriverOpts() && Objects.equals(this.driverOpts(), other.driverOpts()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"DockerVolumeConfiguration").add("Scope", (Object)this.scopeAsString()).add("Autoprovision", (Object)this.autoprovision()).add("Driver", (Object)this.driver()).add("DriverOpts", this.hasDriverOpts() ? this.driverOpts() : null).add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "autoprovision": {
                return Optional.ofNullable(clazz.cast(this.autoprovision()));
            }
            case "driver": {
                return Optional.ofNullable(clazz.cast(this.driver()));
            }
            case "driverOpts": {
                return Optional.ofNullable(clazz.cast(this.driverOpts()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DockerVolumeConfiguration, T> g) {
        return obj -> g.apply((DockerVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scope;
        private Boolean autoprovision;
        private String driver;
        private Map<String, String> driverOpts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DockerVolumeConfiguration model) {
            this.scope(model.scope);
            this.autoprovision(model.autoprovision);
            this.driver(model.driver);
            this.driverOpts(model.driverOpts);
            this.labels(model.labels);
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        @Transient
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        @Transient
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final Boolean getAutoprovision() {
            return this.autoprovision;
        }

        public final void setAutoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
        }

        @Override
        @Transient
        public final Builder autoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
            return this;
        }

        public final String getDriver() {
            return this.driver;
        }

        public final void setDriver(String driver) {
            this.driver = driver;
        }

        @Override
        @Transient
        public final Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public final Map<String, String> getDriverOpts() {
            if (this.driverOpts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.driverOpts;
        }

        public final void setDriverOpts(Map<String, String> driverOpts) {
            this.driverOpts = StringMapCopier.copy(driverOpts);
        }

        @Override
        @Transient
        public final Builder driverOpts(Map<String, String> driverOpts) {
            this.driverOpts = StringMapCopier.copy(driverOpts);
            return this;
        }

        public final Map<String, String> getLabels() {
            if (this.labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = StringMapCopier.copy(labels);
        }

        @Override
        @Transient
        public final Builder labels(Map<String, String> labels) {
            this.labels = StringMapCopier.copy(labels);
            return this;
        }

        public DockerVolumeConfiguration build() {
            return new DockerVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DockerVolumeConfiguration> {
        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder autoprovision(Boolean var1);

        public Builder driver(String var1);

        public Builder driverOpts(Map<String, String> var1);

        public Builder labels(Map<String, String> var1);
    }
}

