/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandLogConfiguration;
import software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteCommandConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecuteCommandConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(ExecuteCommandConfiguration.getter(ExecuteCommandConfiguration::kmsKeyId)).setter(ExecuteCommandConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logging").getter(ExecuteCommandConfiguration.getter(ExecuteCommandConfiguration::loggingAsString)).setter(ExecuteCommandConfiguration.setter(Builder::logging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<ExecuteCommandLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(ExecuteCommandConfiguration.getter(ExecuteCommandConfiguration::logConfiguration)).setter(ExecuteCommandConfiguration.setter(Builder::logConfiguration)).constructor(ExecuteCommandLogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, LOGGING_FIELD, LOG_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String logging;
    private final ExecuteCommandLogConfiguration logConfiguration;

    private ExecuteCommandConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.logging = builder.logging;
        this.logConfiguration = builder.logConfiguration;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final ExecuteCommandLogging logging() {
        return ExecuteCommandLogging.fromValue(this.logging);
    }

    public final String loggingAsString() {
        return this.logging;
    }

    public final ExecuteCommandLogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteCommandConfiguration)) {
            return false;
        }
        ExecuteCommandConfiguration other = (ExecuteCommandConfiguration)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.loggingAsString(), other.loggingAsString()) && Objects.equals(this.logConfiguration(), other.logConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteCommandConfiguration").add("KmsKeyId", (Object)this.kmsKeyId()).add("Logging", (Object)this.loggingAsString()).add("LogConfiguration", (Object)this.logConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.loggingAsString()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteCommandConfiguration, T> g) {
        return obj -> g.apply((ExecuteCommandConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String logging;
        private ExecuteCommandLogConfiguration logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteCommandConfiguration model) {
            this.kmsKeyId(model.kmsKeyId);
            this.logging(model.logging);
            this.logConfiguration(model.logConfiguration);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getLogging() {
            return this.logging;
        }

        public final void setLogging(String logging) {
            this.logging = logging;
        }

        @Override
        @Transient
        public final Builder logging(String logging) {
            this.logging = logging;
            return this;
        }

        @Override
        @Transient
        public final Builder logging(ExecuteCommandLogging logging) {
            this.logging(logging == null ? null : logging.toString());
            return this;
        }

        public final ExecuteCommandLogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(ExecuteCommandLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder logConfiguration(ExecuteCommandLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public ExecuteCommandConfiguration build() {
            return new ExecuteCommandConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecuteCommandConfiguration> {
        public Builder kmsKeyId(String var1);

        public Builder logging(String var1);

        public Builder logging(ExecuteCommandLogging var1);

        public Builder logConfiguration(ExecuteCommandLogConfiguration var1);

        default public Builder logConfiguration(Consumer<ExecuteCommandLogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((ExecuteCommandLogConfiguration)((ExecuteCommandLogConfiguration.Builder)ExecuteCommandLogConfiguration.builder().applyMutation(logConfiguration)).build());
        }
    }
}

