/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaskDefinitionsResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ListTaskDefinitionsResponse> {
    private static final SdkField<List<String>> TASK_DEFINITION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskDefinitionArns").getter(ListTaskDefinitionsResponse.getter(ListTaskDefinitionsResponse::taskDefinitionArns)).setter(ListTaskDefinitionsResponse.setter(Builder::taskDefinitionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTaskDefinitionsResponse.getter(ListTaskDefinitionsResponse::nextToken)).setter(ListTaskDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITION_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> taskDefinitionArns;
    private final String nextToken;

    private ListTaskDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.taskDefinitionArns = builder.taskDefinitionArns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTaskDefinitionArns() {
        return this.taskDefinitionArns != null && !(this.taskDefinitionArns instanceof SdkAutoConstructList);
    }

    public final List<String> taskDefinitionArns() {
        return this.taskDefinitionArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskDefinitionArns() ? this.taskDefinitionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskDefinitionsResponse)) {
            return false;
        }
        ListTaskDefinitionsResponse other = (ListTaskDefinitionsResponse)((Object)obj);
        return this.hasTaskDefinitionArns() == other.hasTaskDefinitionArns() && Objects.equals(this.taskDefinitionArns(), other.taskDefinitionArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTaskDefinitionsResponse").add("TaskDefinitionArns", this.hasTaskDefinitionArns() ? this.taskDefinitionArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskDefinitionArns": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTaskDefinitionsResponse, T> g) {
        return obj -> g.apply((ListTaskDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<String> taskDefinitionArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskDefinitionsResponse model) {
            super(model);
            this.taskDefinitionArns(model.taskDefinitionArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getTaskDefinitionArns() {
            if (this.taskDefinitionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskDefinitionArns;
        }

        public final void setTaskDefinitionArns(Collection<String> taskDefinitionArns) {
            this.taskDefinitionArns = StringListCopier.copy(taskDefinitionArns);
        }

        @Override
        @Transient
        public final Builder taskDefinitionArns(Collection<String> taskDefinitionArns) {
            this.taskDefinitionArns = StringListCopier.copy(taskDefinitionArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder taskDefinitionArns(String ... taskDefinitionArns) {
            this.taskDefinitionArns(Arrays.asList(taskDefinitionArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTaskDefinitionsResponse build() {
            return new ListTaskDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaskDefinitionsResponse> {
        public Builder taskDefinitionArns(Collection<String> var1);

        public Builder taskDefinitionArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

