/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CPUArchitecture {
    X86_64("X86_64"),
    ARM64("ARM64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CPUArchitecture> VALUE_MAP;
    private final String value;

    private CPUArchitecture(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CPUArchitecture fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CPUArchitecture> knownValues() {
        EnumSet<CPUArchitecture> knownValues = EnumSet.allOf(CPUArchitecture.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CPUArchitecture.class, CPUArchitecture::toString);
    }
}

