/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerCondition {
    START("START"),
    COMPLETE("COMPLETE"),
    SUCCESS("SUCCESS"),
    HEALTHY("HEALTHY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerCondition> VALUE_MAP;
    private final String value;

    private ContainerCondition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerCondition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerCondition> knownValues() {
        EnumSet<ContainerCondition> knownValues = EnumSet.allOf(ContainerCondition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerCondition.class, ContainerCondition::toString);
    }
}

