/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaskDefinitionFamiliesResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ListTaskDefinitionFamiliesResponse> {
    private static final SdkField<List<String>> FAMILIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("families").getter(ListTaskDefinitionFamiliesResponse.getter(ListTaskDefinitionFamiliesResponse::families)).setter(ListTaskDefinitionFamiliesResponse.setter(Builder::families)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("families").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTaskDefinitionFamiliesResponse.getter(ListTaskDefinitionFamiliesResponse::nextToken)).setter(ListTaskDefinitionFamiliesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTaskDefinitionFamiliesResponse.memberNameToFieldInitializer();
    private final List<String> families;
    private final String nextToken;

    private ListTaskDefinitionFamiliesResponse(BuilderImpl builder) {
        super(builder);
        this.families = builder.families;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFamilies() {
        return this.families != null && !(this.families instanceof SdkAutoConstructList);
    }

    public final List<String> families() {
        return this.families;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFamilies() ? this.families() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskDefinitionFamiliesResponse)) {
            return false;
        }
        ListTaskDefinitionFamiliesResponse other = (ListTaskDefinitionFamiliesResponse)((Object)obj);
        return this.hasFamilies() == other.hasFamilies() && Objects.equals(this.families(), other.families()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTaskDefinitionFamiliesResponse").add("Families", this.hasFamilies() ? this.families() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "families": {
                return Optional.ofNullable(clazz.cast(this.families()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("families", FAMILIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTaskDefinitionFamiliesResponse, T> g) {
        return obj -> g.apply((ListTaskDefinitionFamiliesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<String> families = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskDefinitionFamiliesResponse model) {
            super(model);
            this.families(model.families);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFamilies() {
            if (this.families instanceof SdkAutoConstructList) {
                return null;
            }
            return this.families;
        }

        public final void setFamilies(Collection<String> families) {
            this.families = StringListCopier.copy(families);
        }

        @Override
        public final Builder families(Collection<String> families) {
            this.families = StringListCopier.copy(families);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder families(String ... families) {
            this.families(Arrays.asList(families));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTaskDefinitionFamiliesResponse build() {
            return new ListTaskDefinitionFamiliesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaskDefinitionFamiliesResponse> {
        public Builder families(Collection<String> var1);

        public Builder families(String ... var1);

        public Builder nextToken(String var1);
    }
}

