/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScaleUnit {
    PERCENT("PERCENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScaleUnit> VALUE_MAP;
    private final String value;

    private ScaleUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScaleUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScaleUnit> knownValues() {
        EnumSet<ScaleUnit> knownValues = EnumSet.allOf(ScaleUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScaleUnit.class, ScaleUnit::toString);
    }
}

