/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters for response received from <code> <a>ListElasticsearchVersions</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListElasticsearchVersionsResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<ListElasticsearchVersionsResponse.Builder, ListElasticsearchVersionsResponse> {
    private static final SdkField<List<String>> ELASTICSEARCH_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListElasticsearchVersionsResponse::elasticsearchVersions))
            .setter(setter(Builder::elasticsearchVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListElasticsearchVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTICSEARCH_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> elasticsearchVersions;

    private final String nextToken;

    private ListElasticsearchVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.elasticsearchVersions = builder.elasticsearchVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ElasticsearchVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasElasticsearchVersions() {
        return elasticsearchVersions != null && !(elasticsearchVersions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ElasticsearchVersions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticsearchVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the ElasticsearchVersions property for this object.
     */
    public List<String> elasticsearchVersions() {
        return elasticsearchVersions;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchVersions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchVersionsResponse)) {
            return false;
        }
        ListElasticsearchVersionsResponse other = (ListElasticsearchVersionsResponse) obj;
        return Objects.equals(elasticsearchVersions(), other.elasticsearchVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListElasticsearchVersionsResponse").add("ElasticsearchVersions", elasticsearchVersions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticsearchVersions":
            return Optional.ofNullable(clazz.cast(elasticsearchVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListElasticsearchVersionsResponse, T> g) {
        return obj -> g.apply((ListElasticsearchVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListElasticsearchVersionsResponse> {
        /**
         * Sets the value of the ElasticsearchVersions property for this object.
         *
         * @param elasticsearchVersions
         *        The new value for the ElasticsearchVersions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersions(Collection<String> elasticsearchVersions);

        /**
         * Sets the value of the ElasticsearchVersions property for this object.
         *
         * @param elasticsearchVersions
         *        The new value for the ElasticsearchVersions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersions(String... elasticsearchVersions);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<String> elasticsearchVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchVersionsResponse model) {
            super(model);
            elasticsearchVersions(model.elasticsearchVersions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getElasticsearchVersions() {
            return elasticsearchVersions;
        }

        @Override
        public final Builder elasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchVersions(String... elasticsearchVersions) {
            elasticsearchVersions(Arrays.asList(elasticsearchVersions));
            return this;
        }

        public final void setElasticsearchVersions(Collection<String> elasticsearchVersions) {
            this.elasticsearchVersions = ElasticsearchVersionListCopier.copy(elasticsearchVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListElasticsearchVersionsResponse build() {
            return new ListElasticsearchVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
