/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse;

public class DescribeOutboundCrossClusterSearchConnectionsIterable
implements SdkIterable<DescribeOutboundCrossClusterSearchConnectionsResponse> {
    private final ElasticsearchClient client;
    private final DescribeOutboundCrossClusterSearchConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOutboundCrossClusterSearchConnectionsIterable(ElasticsearchClient client, DescribeOutboundCrossClusterSearchConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeOutboundCrossClusterSearchConnectionsResponseFetcher();
    }

    public Iterator<DescribeOutboundCrossClusterSearchConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeOutboundCrossClusterSearchConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeOutboundCrossClusterSearchConnectionsResponse> {
        private DescribeOutboundCrossClusterSearchConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOutboundCrossClusterSearchConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOutboundCrossClusterSearchConnectionsResponse nextPage(DescribeOutboundCrossClusterSearchConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOutboundCrossClusterSearchConnectionsIterable.this.client.describeOutboundCrossClusterSearchConnections(DescribeOutboundCrossClusterSearchConnectionsIterable.this.firstRequest);
            }
            return DescribeOutboundCrossClusterSearchConnectionsIterable.this.client.describeOutboundCrossClusterSearchConnections((DescribeOutboundCrossClusterSearchConnectionsRequest)((Object)DescribeOutboundCrossClusterSearchConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

