/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.ReplayDestination;
import software.amazon.awssdk.services.eventbridge.model.ReplayState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplayResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, DescribeReplayResponse> {
    private static final SdkField<String> REPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplayName").getter(DescribeReplayResponse.getter(DescribeReplayResponse::replayName)).setter(DescribeReplayResponse.setter(Builder::replayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayName").build()}).build();
    private static final SdkField<String> REPLAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplayArn").getter(DescribeReplayResponse.getter(DescribeReplayResponse::replayArn)).setter(DescribeReplayResponse.setter(Builder::replayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeReplayResponse.getter(DescribeReplayResponse::description)).setter(DescribeReplayResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeReplayResponse.getter(DescribeReplayResponse::stateAsString)).setter(DescribeReplayResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(DescribeReplayResponse.getter(DescribeReplayResponse::stateReason)).setter(DescribeReplayResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(DescribeReplayResponse.getter(DescribeReplayResponse::eventSourceArn)).setter(DescribeReplayResponse.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<ReplayDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(DescribeReplayResponse.getter(DescribeReplayResponse::destination)).setter(DescribeReplayResponse.setter(Builder::destination)).constructor(ReplayDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<Instant> EVENT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventStartTime").getter(DescribeReplayResponse.getter(DescribeReplayResponse::eventStartTime)).setter(DescribeReplayResponse.setter(Builder::eventStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStartTime").build()}).build();
    private static final SdkField<Instant> EVENT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventEndTime").getter(DescribeReplayResponse.getter(DescribeReplayResponse::eventEndTime)).setter(DescribeReplayResponse.setter(Builder::eventEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventEndTime").build()}).build();
    private static final SdkField<Instant> EVENT_LAST_REPLAYED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventLastReplayedTime").getter(DescribeReplayResponse.getter(DescribeReplayResponse::eventLastReplayedTime)).setter(DescribeReplayResponse.setter(Builder::eventLastReplayedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLastReplayedTime").build()}).build();
    private static final SdkField<Instant> REPLAY_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplayStartTime").getter(DescribeReplayResponse.getter(DescribeReplayResponse::replayStartTime)).setter(DescribeReplayResponse.setter(Builder::replayStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayStartTime").build()}).build();
    private static final SdkField<Instant> REPLAY_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplayEndTime").getter(DescribeReplayResponse.getter(DescribeReplayResponse::replayEndTime)).setter(DescribeReplayResponse.setter(Builder::replayEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_NAME_FIELD, REPLAY_ARN_FIELD, DESCRIPTION_FIELD, STATE_FIELD, STATE_REASON_FIELD, EVENT_SOURCE_ARN_FIELD, DESTINATION_FIELD, EVENT_START_TIME_FIELD, EVENT_END_TIME_FIELD, EVENT_LAST_REPLAYED_TIME_FIELD, REPLAY_START_TIME_FIELD, REPLAY_END_TIME_FIELD));
    private final String replayName;
    private final String replayArn;
    private final String description;
    private final String state;
    private final String stateReason;
    private final String eventSourceArn;
    private final ReplayDestination destination;
    private final Instant eventStartTime;
    private final Instant eventEndTime;
    private final Instant eventLastReplayedTime;
    private final Instant replayStartTime;
    private final Instant replayEndTime;

    private DescribeReplayResponse(BuilderImpl builder) {
        super(builder);
        this.replayName = builder.replayName;
        this.replayArn = builder.replayArn;
        this.description = builder.description;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.eventSourceArn = builder.eventSourceArn;
        this.destination = builder.destination;
        this.eventStartTime = builder.eventStartTime;
        this.eventEndTime = builder.eventEndTime;
        this.eventLastReplayedTime = builder.eventLastReplayedTime;
        this.replayStartTime = builder.replayStartTime;
        this.replayEndTime = builder.replayEndTime;
    }

    public String replayName() {
        return this.replayName;
    }

    public String replayArn() {
        return this.replayArn;
    }

    public String description() {
        return this.description;
    }

    public ReplayState state() {
        return ReplayState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public String eventSourceArn() {
        return this.eventSourceArn;
    }

    public ReplayDestination destination() {
        return this.destination;
    }

    public Instant eventStartTime() {
        return this.eventStartTime;
    }

    public Instant eventEndTime() {
        return this.eventEndTime;
    }

    public Instant eventLastReplayedTime() {
        return this.eventLastReplayedTime;
    }

    public Instant replayStartTime() {
        return this.replayStartTime;
    }

    public Instant replayEndTime() {
        return this.replayEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventLastReplayedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayEndTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplayResponse)) {
            return false;
        }
        DescribeReplayResponse other = (DescribeReplayResponse)((Object)obj);
        return Objects.equals(this.replayName(), other.replayName()) && Objects.equals(this.replayArn(), other.replayArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.eventStartTime(), other.eventStartTime()) && Objects.equals(this.eventEndTime(), other.eventEndTime()) && Objects.equals(this.eventLastReplayedTime(), other.eventLastReplayedTime()) && Objects.equals(this.replayStartTime(), other.replayStartTime()) && Objects.equals(this.replayEndTime(), other.replayEndTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplayResponse").add("ReplayName", (Object)this.replayName()).add("ReplayArn", (Object)this.replayArn()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("EventSourceArn", (Object)this.eventSourceArn()).add("Destination", (Object)this.destination()).add("EventStartTime", (Object)this.eventStartTime()).add("EventEndTime", (Object)this.eventEndTime()).add("EventLastReplayedTime", (Object)this.eventLastReplayedTime()).add("ReplayStartTime", (Object)this.replayStartTime()).add("ReplayEndTime", (Object)this.replayEndTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplayName": {
                return Optional.ofNullable(clazz.cast(this.replayName()));
            }
            case "ReplayArn": {
                return Optional.ofNullable(clazz.cast(this.replayArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "EventStartTime": {
                return Optional.ofNullable(clazz.cast(this.eventStartTime()));
            }
            case "EventEndTime": {
                return Optional.ofNullable(clazz.cast(this.eventEndTime()));
            }
            case "EventLastReplayedTime": {
                return Optional.ofNullable(clazz.cast(this.eventLastReplayedTime()));
            }
            case "ReplayStartTime": {
                return Optional.ofNullable(clazz.cast(this.replayStartTime()));
            }
            case "ReplayEndTime": {
                return Optional.ofNullable(clazz.cast(this.replayEndTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplayResponse, T> g) {
        return obj -> g.apply((DescribeReplayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String replayName;
        private String replayArn;
        private String description;
        private String state;
        private String stateReason;
        private String eventSourceArn;
        private ReplayDestination destination;
        private Instant eventStartTime;
        private Instant eventEndTime;
        private Instant eventLastReplayedTime;
        private Instant replayStartTime;
        private Instant replayEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplayResponse model) {
            super(model);
            this.replayName(model.replayName);
            this.replayArn(model.replayArn);
            this.description(model.description);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.eventSourceArn(model.eventSourceArn);
            this.destination(model.destination);
            this.eventStartTime(model.eventStartTime);
            this.eventEndTime(model.eventEndTime);
            this.eventLastReplayedTime(model.eventLastReplayedTime);
            this.replayStartTime(model.replayStartTime);
            this.replayEndTime(model.replayEndTime);
        }

        public final String getReplayName() {
            return this.replayName;
        }

        @Override
        public final Builder replayName(String replayName) {
            this.replayName = replayName;
            return this;
        }

        public final void setReplayName(String replayName) {
            this.replayName = replayName;
        }

        public final String getReplayArn() {
            return this.replayArn;
        }

        @Override
        public final Builder replayArn(String replayArn) {
            this.replayArn = replayArn;
            return this;
        }

        public final void setReplayArn(String replayArn) {
            this.replayArn = replayArn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final ReplayDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(ReplayDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(ReplayDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Instant getEventStartTime() {
            return this.eventStartTime;
        }

        @Override
        public final Builder eventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public final void setEventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
        }

        public final Instant getEventEndTime() {
            return this.eventEndTime;
        }

        @Override
        public final Builder eventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public final void setEventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
        }

        public final Instant getEventLastReplayedTime() {
            return this.eventLastReplayedTime;
        }

        @Override
        public final Builder eventLastReplayedTime(Instant eventLastReplayedTime) {
            this.eventLastReplayedTime = eventLastReplayedTime;
            return this;
        }

        public final void setEventLastReplayedTime(Instant eventLastReplayedTime) {
            this.eventLastReplayedTime = eventLastReplayedTime;
        }

        public final Instant getReplayStartTime() {
            return this.replayStartTime;
        }

        @Override
        public final Builder replayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
            return this;
        }

        public final void setReplayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
        }

        public final Instant getReplayEndTime() {
            return this.replayEndTime;
        }

        @Override
        public final Builder replayEndTime(Instant replayEndTime) {
            this.replayEndTime = replayEndTime;
            return this;
        }

        public final void setReplayEndTime(Instant replayEndTime) {
            this.replayEndTime = replayEndTime;
        }

        @Override
        public DescribeReplayResponse build() {
            return new DescribeReplayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplayResponse> {
        public Builder replayName(String var1);

        public Builder replayArn(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(ReplayState var1);

        public Builder stateReason(String var1);

        public Builder eventSourceArn(String var1);

        public Builder destination(ReplayDestination var1);

        default public Builder destination(Consumer<ReplayDestination.Builder> destination) {
            return this.destination((ReplayDestination)((ReplayDestination.Builder)ReplayDestination.builder().applyMutation(destination)).build());
        }

        public Builder eventStartTime(Instant var1);

        public Builder eventEndTime(Instant var1);

        public Builder eventLastReplayedTime(Instant var1);

        public Builder replayStartTime(Instant var1);

        public Builder replayEndTime(Instant var1);
    }
}

