/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationDescription;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationDescription;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationDescription;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationDescription> {
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationId").getter(DestinationDescription.getter(DestinationDescription::destinationId)).setter(DestinationDescription.setter(Builder::destinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationId").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DestinationDescription").getter(DestinationDescription.getter(DestinationDescription::s3DestinationDescription)).setter(DestinationDescription.setter(Builder::s3DestinationDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationDescription").build()}).build();
    private static final SdkField<ExtendedS3DestinationDescription> EXTENDED_S3_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExtendedS3DestinationDescription").getter(DestinationDescription.getter(DestinationDescription::extendedS3DestinationDescription)).setter(DestinationDescription.setter(Builder::extendedS3DestinationDescription)).constructor(ExtendedS3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedS3DestinationDescription").build()}).build();
    private static final SdkField<RedshiftDestinationDescription> REDSHIFT_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftDestinationDescription").getter(DestinationDescription.getter(DestinationDescription::redshiftDestinationDescription)).setter(DestinationDescription.setter(Builder::redshiftDestinationDescription)).constructor(RedshiftDestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDestinationDescription").build()}).build();
    private static final SdkField<ElasticsearchDestinationDescription> ELASTICSEARCH_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticsearchDestinationDescription").getter(DestinationDescription.getter(DestinationDescription::elasticsearchDestinationDescription)).setter(DestinationDescription.setter(Builder::elasticsearchDestinationDescription)).constructor(ElasticsearchDestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchDestinationDescription").build()}).build();
    private static final SdkField<AmazonopensearchserviceDestinationDescription> AMAZONOPENSEARCHSERVICE_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonopensearchserviceDestinationDescription").getter(DestinationDescription.getter(DestinationDescription::amazonopensearchserviceDestinationDescription)).setter(DestinationDescription.setter(Builder::amazonopensearchserviceDestinationDescription)).constructor(AmazonopensearchserviceDestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonopensearchserviceDestinationDescription").build()}).build();
    private static final SdkField<SplunkDestinationDescription> SPLUNK_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SplunkDestinationDescription").getter(DestinationDescription.getter(DestinationDescription::splunkDestinationDescription)).setter(DestinationDescription.setter(Builder::splunkDestinationDescription)).constructor(SplunkDestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplunkDestinationDescription").build()}).build();
    private static final SdkField<HttpEndpointDestinationDescription> HTTP_ENDPOINT_DESTINATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpEndpointDestinationDescription").getter(DestinationDescription.getter(DestinationDescription::httpEndpointDestinationDescription)).setter(DestinationDescription.setter(Builder::httpEndpointDestinationDescription)).constructor(HttpEndpointDestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointDestinationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ID_FIELD, S3_DESTINATION_DESCRIPTION_FIELD, EXTENDED_S3_DESTINATION_DESCRIPTION_FIELD, REDSHIFT_DESTINATION_DESCRIPTION_FIELD, ELASTICSEARCH_DESTINATION_DESCRIPTION_FIELD, AMAZONOPENSEARCHSERVICE_DESTINATION_DESCRIPTION_FIELD, SPLUNK_DESTINATION_DESCRIPTION_FIELD, HTTP_ENDPOINT_DESTINATION_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationId;
    private final S3DestinationDescription s3DestinationDescription;
    private final ExtendedS3DestinationDescription extendedS3DestinationDescription;
    private final RedshiftDestinationDescription redshiftDestinationDescription;
    private final ElasticsearchDestinationDescription elasticsearchDestinationDescription;
    private final AmazonopensearchserviceDestinationDescription amazonopensearchserviceDestinationDescription;
    private final SplunkDestinationDescription splunkDestinationDescription;
    private final HttpEndpointDestinationDescription httpEndpointDestinationDescription;

    private DestinationDescription(BuilderImpl builder) {
        this.destinationId = builder.destinationId;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.extendedS3DestinationDescription = builder.extendedS3DestinationDescription;
        this.redshiftDestinationDescription = builder.redshiftDestinationDescription;
        this.elasticsearchDestinationDescription = builder.elasticsearchDestinationDescription;
        this.amazonopensearchserviceDestinationDescription = builder.amazonopensearchserviceDestinationDescription;
        this.splunkDestinationDescription = builder.splunkDestinationDescription;
        this.httpEndpointDestinationDescription = builder.httpEndpointDestinationDescription;
    }

    public final String destinationId() {
        return this.destinationId;
    }

    public final S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public final ExtendedS3DestinationDescription extendedS3DestinationDescription() {
        return this.extendedS3DestinationDescription;
    }

    public final RedshiftDestinationDescription redshiftDestinationDescription() {
        return this.redshiftDestinationDescription;
    }

    public final ElasticsearchDestinationDescription elasticsearchDestinationDescription() {
        return this.elasticsearchDestinationDescription;
    }

    public final AmazonopensearchserviceDestinationDescription amazonopensearchserviceDestinationDescription() {
        return this.amazonopensearchserviceDestinationDescription;
    }

    public final SplunkDestinationDescription splunkDestinationDescription() {
        return this.splunkDestinationDescription;
    }

    public final HttpEndpointDestinationDescription httpEndpointDestinationDescription() {
        return this.httpEndpointDestinationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedS3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonopensearchserviceDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.splunkDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointDestinationDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationDescription)) {
            return false;
        }
        DestinationDescription other = (DestinationDescription)obj;
        return Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.s3DestinationDescription(), other.s3DestinationDescription()) && Objects.equals(this.extendedS3DestinationDescription(), other.extendedS3DestinationDescription()) && Objects.equals(this.redshiftDestinationDescription(), other.redshiftDestinationDescription()) && Objects.equals(this.elasticsearchDestinationDescription(), other.elasticsearchDestinationDescription()) && Objects.equals(this.amazonopensearchserviceDestinationDescription(), other.amazonopensearchserviceDestinationDescription()) && Objects.equals(this.splunkDestinationDescription(), other.splunkDestinationDescription()) && Objects.equals(this.httpEndpointDestinationDescription(), other.httpEndpointDestinationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationDescription").add("DestinationId", (Object)this.destinationId()).add("S3DestinationDescription", (Object)this.s3DestinationDescription()).add("ExtendedS3DestinationDescription", (Object)this.extendedS3DestinationDescription()).add("RedshiftDestinationDescription", (Object)this.redshiftDestinationDescription()).add("ElasticsearchDestinationDescription", (Object)this.elasticsearchDestinationDescription()).add("AmazonopensearchserviceDestinationDescription", (Object)this.amazonopensearchserviceDestinationDescription()).add("SplunkDestinationDescription", (Object)this.splunkDestinationDescription()).add("HttpEndpointDestinationDescription", (Object)this.httpEndpointDestinationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
            case "S3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationDescription()));
            }
            case "ExtendedS3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.extendedS3DestinationDescription()));
            }
            case "RedshiftDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.redshiftDestinationDescription()));
            }
            case "ElasticsearchDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchDestinationDescription()));
            }
            case "AmazonopensearchserviceDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.amazonopensearchserviceDestinationDescription()));
            }
            case "SplunkDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.splunkDestinationDescription()));
            }
            case "HttpEndpointDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointDestinationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationDescription, T> g) {
        return obj -> g.apply((DestinationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationId;
        private S3DestinationDescription s3DestinationDescription;
        private ExtendedS3DestinationDescription extendedS3DestinationDescription;
        private RedshiftDestinationDescription redshiftDestinationDescription;
        private ElasticsearchDestinationDescription elasticsearchDestinationDescription;
        private AmazonopensearchserviceDestinationDescription amazonopensearchserviceDestinationDescription;
        private SplunkDestinationDescription splunkDestinationDescription;
        private HttpEndpointDestinationDescription httpEndpointDestinationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationDescription model) {
            this.destinationId(model.destinationId);
            this.s3DestinationDescription(model.s3DestinationDescription);
            this.extendedS3DestinationDescription(model.extendedS3DestinationDescription);
            this.redshiftDestinationDescription(model.redshiftDestinationDescription);
            this.elasticsearchDestinationDescription(model.elasticsearchDestinationDescription);
            this.amazonopensearchserviceDestinationDescription(model.amazonopensearchserviceDestinationDescription);
            this.splunkDestinationDescription(model.splunkDestinationDescription);
            this.httpEndpointDestinationDescription(model.httpEndpointDestinationDescription);
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        @Transient
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return this.s3DestinationDescription != null ? this.s3DestinationDescription.toBuilder() : null;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final ExtendedS3DestinationDescription.Builder getExtendedS3DestinationDescription() {
            return this.extendedS3DestinationDescription != null ? this.extendedS3DestinationDescription.toBuilder() : null;
        }

        public final void setExtendedS3DestinationDescription(ExtendedS3DestinationDescription.BuilderImpl extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription != null ? extendedS3DestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription;
            return this;
        }

        public final RedshiftDestinationDescription.Builder getRedshiftDestinationDescription() {
            return this.redshiftDestinationDescription != null ? this.redshiftDestinationDescription.toBuilder() : null;
        }

        public final void setRedshiftDestinationDescription(RedshiftDestinationDescription.BuilderImpl redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription != null ? redshiftDestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder redshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription;
            return this;
        }

        public final ElasticsearchDestinationDescription.Builder getElasticsearchDestinationDescription() {
            return this.elasticsearchDestinationDescription != null ? this.elasticsearchDestinationDescription.toBuilder() : null;
        }

        public final void setElasticsearchDestinationDescription(ElasticsearchDestinationDescription.BuilderImpl elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription != null ? elasticsearchDestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription;
            return this;
        }

        public final AmazonopensearchserviceDestinationDescription.Builder getAmazonopensearchserviceDestinationDescription() {
            return this.amazonopensearchserviceDestinationDescription != null ? this.amazonopensearchserviceDestinationDescription.toBuilder() : null;
        }

        public final void setAmazonopensearchserviceDestinationDescription(AmazonopensearchserviceDestinationDescription.BuilderImpl amazonopensearchserviceDestinationDescription) {
            this.amazonopensearchserviceDestinationDescription = amazonopensearchserviceDestinationDescription != null ? amazonopensearchserviceDestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder amazonopensearchserviceDestinationDescription(AmazonopensearchserviceDestinationDescription amazonopensearchserviceDestinationDescription) {
            this.amazonopensearchserviceDestinationDescription = amazonopensearchserviceDestinationDescription;
            return this;
        }

        public final SplunkDestinationDescription.Builder getSplunkDestinationDescription() {
            return this.splunkDestinationDescription != null ? this.splunkDestinationDescription.toBuilder() : null;
        }

        public final void setSplunkDestinationDescription(SplunkDestinationDescription.BuilderImpl splunkDestinationDescription) {
            this.splunkDestinationDescription = splunkDestinationDescription != null ? splunkDestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder splunkDestinationDescription(SplunkDestinationDescription splunkDestinationDescription) {
            this.splunkDestinationDescription = splunkDestinationDescription;
            return this;
        }

        public final HttpEndpointDestinationDescription.Builder getHttpEndpointDestinationDescription() {
            return this.httpEndpointDestinationDescription != null ? this.httpEndpointDestinationDescription.toBuilder() : null;
        }

        public final void setHttpEndpointDestinationDescription(HttpEndpointDestinationDescription.BuilderImpl httpEndpointDestinationDescription) {
            this.httpEndpointDestinationDescription = httpEndpointDestinationDescription != null ? httpEndpointDestinationDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder httpEndpointDestinationDescription(HttpEndpointDestinationDescription httpEndpointDestinationDescription) {
            this.httpEndpointDestinationDescription = httpEndpointDestinationDescription;
            return this;
        }

        public DestinationDescription build() {
            return new DestinationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationDescription> {
        public Builder destinationId(String var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        default public Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return this.s3DestinationDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3DestinationDescription)).build());
        }

        public Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription var1);

        default public Builder extendedS3DestinationDescription(Consumer<ExtendedS3DestinationDescription.Builder> extendedS3DestinationDescription) {
            return this.extendedS3DestinationDescription((ExtendedS3DestinationDescription)((ExtendedS3DestinationDescription.Builder)ExtendedS3DestinationDescription.builder().applyMutation(extendedS3DestinationDescription)).build());
        }

        public Builder redshiftDestinationDescription(RedshiftDestinationDescription var1);

        default public Builder redshiftDestinationDescription(Consumer<RedshiftDestinationDescription.Builder> redshiftDestinationDescription) {
            return this.redshiftDestinationDescription((RedshiftDestinationDescription)((RedshiftDestinationDescription.Builder)RedshiftDestinationDescription.builder().applyMutation(redshiftDestinationDescription)).build());
        }

        public Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription var1);

        default public Builder elasticsearchDestinationDescription(Consumer<ElasticsearchDestinationDescription.Builder> elasticsearchDestinationDescription) {
            return this.elasticsearchDestinationDescription((ElasticsearchDestinationDescription)((ElasticsearchDestinationDescription.Builder)ElasticsearchDestinationDescription.builder().applyMutation(elasticsearchDestinationDescription)).build());
        }

        public Builder amazonopensearchserviceDestinationDescription(AmazonopensearchserviceDestinationDescription var1);

        default public Builder amazonopensearchserviceDestinationDescription(Consumer<AmazonopensearchserviceDestinationDescription.Builder> amazonopensearchserviceDestinationDescription) {
            return this.amazonopensearchserviceDestinationDescription((AmazonopensearchserviceDestinationDescription)((AmazonopensearchserviceDestinationDescription.Builder)AmazonopensearchserviceDestinationDescription.builder().applyMutation(amazonopensearchserviceDestinationDescription)).build());
        }

        public Builder splunkDestinationDescription(SplunkDestinationDescription var1);

        default public Builder splunkDestinationDescription(Consumer<SplunkDestinationDescription.Builder> splunkDestinationDescription) {
            return this.splunkDestinationDescription((SplunkDestinationDescription)((SplunkDestinationDescription.Builder)SplunkDestinationDescription.builder().applyMutation(splunkDestinationDescription)).build());
        }

        public Builder httpEndpointDestinationDescription(HttpEndpointDestinationDescription var1);

        default public Builder httpEndpointDestinationDescription(Consumer<HttpEndpointDestinationDescription.Builder> httpEndpointDestinationDescription) {
            return this.httpEndpointDestinationDescription((HttpEndpointDestinationDescription)((HttpEndpointDestinationDescription.Builder)HttpEndpointDestinationDescription.builder().applyMutation(httpEndpointDestinationDescription)).build());
        }
    }
}

