/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateAction;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateActionMapCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateExperimentOptions;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateLogConfiguration;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateReportConfiguration;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateStopCondition;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateStopConditionListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateTarget;
import software.amazon.awssdk.services.fis.model.ExperimentTemplateTargetMapCopier;
import software.amazon.awssdk.services.fis.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentTemplate> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ExperimentTemplate.getter(ExperimentTemplate::id)).setter(ExperimentTemplate.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ExperimentTemplate.getter(ExperimentTemplate::arn)).setter(ExperimentTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ExperimentTemplate.getter(ExperimentTemplate::description)).setter(ExperimentTemplate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, ExperimentTemplateTarget>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targets").getter(ExperimentTemplate.getter(ExperimentTemplate::targets)).setter(ExperimentTemplate.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ExperimentTemplateAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("actions").getter(ExperimentTemplate.getter(ExperimentTemplate::actions)).setter(ExperimentTemplate.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ExperimentTemplateStopCondition>> STOP_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stopConditions").getter(ExperimentTemplate.getter(ExperimentTemplate::stopConditions)).setter(ExperimentTemplate.setter(Builder::stopConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTemplateStopCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ExperimentTemplate.getter(ExperimentTemplate::creationTime)).setter(ExperimentTemplate.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(ExperimentTemplate.getter(ExperimentTemplate::lastUpdateTime)).setter(ExperimentTemplate.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ExperimentTemplate.getter(ExperimentTemplate::roleArn)).setter(ExperimentTemplate.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ExperimentTemplate.getter(ExperimentTemplate::tags)).setter(ExperimentTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ExperimentTemplateLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(ExperimentTemplate.getter(ExperimentTemplate::logConfiguration)).setter(ExperimentTemplate.setter(Builder::logConfiguration)).constructor(ExperimentTemplateLogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<ExperimentTemplateExperimentOptions> EXPERIMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("experimentOptions").getter(ExperimentTemplate.getter(ExperimentTemplate::experimentOptions)).setter(ExperimentTemplate.setter(Builder::experimentOptions)).constructor(ExperimentTemplateExperimentOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentOptions").build()}).build();
    private static final SdkField<Long> TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetAccountConfigurationsCount").getter(ExperimentTemplate.getter(ExperimentTemplate::targetAccountConfigurationsCount)).setter(ExperimentTemplate.setter(Builder::targetAccountConfigurationsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountConfigurationsCount").build()}).build();
    private static final SdkField<ExperimentTemplateReportConfiguration> EXPERIMENT_REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("experimentReportConfiguration").getter(ExperimentTemplate.getter(ExperimentTemplate::experimentReportConfiguration)).setter(ExperimentTemplate.setter(Builder::experimentReportConfiguration)).constructor(ExperimentTemplateReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentReportConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, ACTIONS_FIELD, STOP_CONDITIONS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, LOG_CONFIGURATION_FIELD, EXPERIMENT_OPTIONS_FIELD, TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD, EXPERIMENT_REPORT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExperimentTemplate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String description;
    private final Map<String, ExperimentTemplateTarget> targets;
    private final Map<String, ExperimentTemplateAction> actions;
    private final List<ExperimentTemplateStopCondition> stopConditions;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String roleArn;
    private final Map<String, String> tags;
    private final ExperimentTemplateLogConfiguration logConfiguration;
    private final ExperimentTemplateExperimentOptions experimentOptions;
    private final Long targetAccountConfigurationsCount;
    private final ExperimentTemplateReportConfiguration experimentReportConfiguration;

    private ExperimentTemplate(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.stopConditions = builder.stopConditions;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.logConfiguration = builder.logConfiguration;
        this.experimentOptions = builder.experimentOptions;
        this.targetAccountConfigurationsCount = builder.targetAccountConfigurationsCount;
        this.experimentReportConfiguration = builder.experimentReportConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExperimentTemplateTarget> targets() {
        return this.targets;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExperimentTemplateAction> actions() {
        return this.actions;
    }

    public final boolean hasStopConditions() {
        return this.stopConditions != null && !(this.stopConditions instanceof SdkAutoConstructList);
    }

    public final List<ExperimentTemplateStopCondition> stopConditions() {
        return this.stopConditions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ExperimentTemplateLogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final ExperimentTemplateExperimentOptions experimentOptions() {
        return this.experimentOptions;
    }

    public final Long targetAccountConfigurationsCount() {
        return this.targetAccountConfigurationsCount;
    }

    public final ExperimentTemplateReportConfiguration experimentReportConfiguration() {
        return this.experimentReportConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopConditions() ? this.stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAccountConfigurationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentReportConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplate)) {
            return false;
        }
        ExperimentTemplate other = (ExperimentTemplate)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasStopConditions() == other.hasStopConditions() && Objects.equals(this.stopConditions(), other.stopConditions()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.experimentOptions(), other.experimentOptions()) && Objects.equals(this.targetAccountConfigurationsCount(), other.targetAccountConfigurationsCount()) && Objects.equals(this.experimentReportConfiguration(), other.experimentReportConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentTemplate").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Targets", this.hasTargets() ? this.targets() : null).add("Actions", this.hasActions() ? this.actions() : null).add("StopConditions", this.hasStopConditions() ? this.stopConditions() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("LogConfiguration", (Object)this.logConfiguration()).add("ExperimentOptions", (Object)this.experimentOptions()).add("TargetAccountConfigurationsCount", (Object)this.targetAccountConfigurationsCount()).add("ExperimentReportConfiguration", (Object)this.experimentReportConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "stopConditions": {
                return Optional.ofNullable(clazz.cast(this.stopConditions()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "experimentOptions": {
                return Optional.ofNullable(clazz.cast(this.experimentOptions()));
            }
            case "targetAccountConfigurationsCount": {
                return Optional.ofNullable(clazz.cast(this.targetAccountConfigurationsCount()));
            }
            case "experimentReportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.experimentReportConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("stopConditions", STOP_CONDITIONS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("experimentOptions", EXPERIMENT_OPTIONS_FIELD);
        map.put("targetAccountConfigurationsCount", TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD);
        map.put("experimentReportConfiguration", EXPERIMENT_REPORT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplate, T> g) {
        return obj -> g.apply((ExperimentTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String description;
        private Map<String, ExperimentTemplateTarget> targets = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ExperimentTemplateAction> actions = DefaultSdkAutoConstructMap.getInstance();
        private List<ExperimentTemplateStopCondition> stopConditions = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ExperimentTemplateLogConfiguration logConfiguration;
        private ExperimentTemplateExperimentOptions experimentOptions;
        private Long targetAccountConfigurationsCount;
        private ExperimentTemplateReportConfiguration experimentReportConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplate model) {
            this.id(model.id);
            this.arn(model.arn);
            this.description(model.description);
            this.targets(model.targets);
            this.actions(model.actions);
            this.stopConditions(model.stopConditions);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.logConfiguration(model.logConfiguration);
            this.experimentOptions(model.experimentOptions);
            this.targetAccountConfigurationsCount(model.targetAccountConfigurationsCount);
            this.experimentReportConfiguration(model.experimentReportConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ExperimentTemplateTarget.Builder> getTargets() {
            Map<String, ExperimentTemplateTarget.Builder> result = ExperimentTemplateTargetMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, ExperimentTemplateTarget.BuilderImpl> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Map<String, ExperimentTemplateTarget> targets) {
            this.targets = ExperimentTemplateTargetMapCopier.copy(targets);
            return this;
        }

        public final Map<String, ExperimentTemplateAction.Builder> getActions() {
            Map<String, ExperimentTemplateAction.Builder> result = ExperimentTemplateActionMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ExperimentTemplateAction.BuilderImpl> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Map<String, ExperimentTemplateAction> actions) {
            this.actions = ExperimentTemplateActionMapCopier.copy(actions);
            return this;
        }

        public final List<ExperimentTemplateStopCondition.Builder> getStopConditions() {
            List<ExperimentTemplateStopCondition.Builder> result = ExperimentTemplateStopConditionListCopier.copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<ExperimentTemplateStopCondition.BuilderImpl> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        public final Builder stopConditions(Collection<ExperimentTemplateStopCondition> stopConditions) {
            this.stopConditions = ExperimentTemplateStopConditionListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(ExperimentTemplateStopCondition ... stopConditions) {
            this.stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder> ... stopConditions) {
            this.stopConditions(Stream.of(stopConditions).map(c -> (ExperimentTemplateStopCondition)((ExperimentTemplateStopCondition.Builder)ExperimentTemplateStopCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExperimentTemplateLogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(ExperimentTemplateLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(ExperimentTemplateLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final ExperimentTemplateExperimentOptions.Builder getExperimentOptions() {
            return this.experimentOptions != null ? this.experimentOptions.toBuilder() : null;
        }

        public final void setExperimentOptions(ExperimentTemplateExperimentOptions.BuilderImpl experimentOptions) {
            this.experimentOptions = experimentOptions != null ? experimentOptions.build() : null;
        }

        @Override
        public final Builder experimentOptions(ExperimentTemplateExperimentOptions experimentOptions) {
            this.experimentOptions = experimentOptions;
            return this;
        }

        public final Long getTargetAccountConfigurationsCount() {
            return this.targetAccountConfigurationsCount;
        }

        public final void setTargetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
            this.targetAccountConfigurationsCount = targetAccountConfigurationsCount;
        }

        @Override
        public final Builder targetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
            this.targetAccountConfigurationsCount = targetAccountConfigurationsCount;
            return this;
        }

        public final ExperimentTemplateReportConfiguration.Builder getExperimentReportConfiguration() {
            return this.experimentReportConfiguration != null ? this.experimentReportConfiguration.toBuilder() : null;
        }

        public final void setExperimentReportConfiguration(ExperimentTemplateReportConfiguration.BuilderImpl experimentReportConfiguration) {
            this.experimentReportConfiguration = experimentReportConfiguration != null ? experimentReportConfiguration.build() : null;
        }

        @Override
        public final Builder experimentReportConfiguration(ExperimentTemplateReportConfiguration experimentReportConfiguration) {
            this.experimentReportConfiguration = experimentReportConfiguration;
            return this;
        }

        public ExperimentTemplate build() {
            return new ExperimentTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentTemplate> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder targets(Map<String, ExperimentTemplateTarget> var1);

        public Builder actions(Map<String, ExperimentTemplateAction> var1);

        public Builder stopConditions(Collection<ExperimentTemplateStopCondition> var1);

        public Builder stopConditions(ExperimentTemplateStopCondition ... var1);

        public Builder stopConditions(Consumer<ExperimentTemplateStopCondition.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder logConfiguration(ExperimentTemplateLogConfiguration var1);

        default public Builder logConfiguration(Consumer<ExperimentTemplateLogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((ExperimentTemplateLogConfiguration)((ExperimentTemplateLogConfiguration.Builder)ExperimentTemplateLogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder experimentOptions(ExperimentTemplateExperimentOptions var1);

        default public Builder experimentOptions(Consumer<ExperimentTemplateExperimentOptions.Builder> experimentOptions) {
            return this.experimentOptions((ExperimentTemplateExperimentOptions)((ExperimentTemplateExperimentOptions.Builder)ExperimentTemplateExperimentOptions.builder().applyMutation(experimentOptions)).build());
        }

        public Builder targetAccountConfigurationsCount(Long var1);

        public Builder experimentReportConfiguration(ExperimentTemplateReportConfiguration var1);

        default public Builder experimentReportConfiguration(Consumer<ExperimentTemplateReportConfiguration.Builder> experimentReportConfiguration) {
            return this.experimentReportConfiguration((ExperimentTemplateReportConfiguration)((ExperimentTemplateReportConfiguration.Builder)ExperimentTemplateReportConfiguration.builder().applyMutation(experimentReportConfiguration)).build());
        }
    }
}

