/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataRepositoryTaskRequest extends FSxRequest implements
        ToCopyableBuilder<CreateDataRepositoryTaskRequest.Builder, CreateDataRepositoryTaskRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDataRepositoryTaskRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDataRepositoryTaskRequest::paths))
            .setter(setter(Builder::paths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDataRepositoryTaskRequest::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<CompletionReport> REPORT_FIELD = SdkField.<CompletionReport> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDataRepositoryTaskRequest::report)).setter(setter(Builder::report))
            .constructor(CompletionReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Report").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDataRepositoryTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateDataRepositoryTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PATHS_FIELD,
            FILE_SYSTEM_ID_FIELD, REPORT_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private final String type;

    private final List<String> paths;

    private final String fileSystemId;

    private final CompletionReport report;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private CreateDataRepositoryTaskRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.paths = builder.paths;
        this.fileSystemId = builder.fileSystemId;
        this.report = builder.report;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the type of data repository task to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataRepositoryTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of data repository task to create.
     * @see DataRepositoryTaskType
     */
    public DataRepositoryTaskType type() {
        return DataRepositoryTaskType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of data repository task to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataRepositoryTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of data repository task to create.
     * @see DataRepositoryTaskType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * Returns true if the Paths property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPaths() {
        return paths != null && !(paths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed. The
     * default path is the file system root directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPaths()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is
     *         processed. The default path is the file system root directory.
     */
    public List<String> paths() {
        return paths;
    }

    /**
     * Returns the value of the FileSystemId property for this object.
     * 
     * @return The value of the FileSystemId property for this object.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport
     * provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the
     * <code>Scope</code> parameter.
     * </p>
     * 
     * @return Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A
     *         CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria
     *         specified by the <code>Scope</code> parameter.
     */
    public CompletionReport report() {
        return report;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paths());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(report());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataRepositoryTaskRequest)) {
            return false;
        }
        CreateDataRepositoryTaskRequest other = (CreateDataRepositoryTaskRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(paths(), other.paths())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(report(), other.report())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDataRepositoryTaskRequest").add("Type", typeAsString()).add("Paths", paths())
                .add("FileSystemId", fileSystemId()).add("Report", report()).add("ClientRequestToken", clientRequestToken())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Paths":
            return Optional.ofNullable(clazz.cast(paths()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "Report":
            return Optional.ofNullable(clazz.cast(report()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataRepositoryTaskRequest, T> g) {
        return obj -> g.apply((CreateDataRepositoryTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataRepositoryTaskRequest> {
        /**
         * <p>
         * Specifies the type of data repository task to create.
         * </p>
         * 
         * @param type
         *        Specifies the type of data repository task to create.
         * @see DataRepositoryTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryTaskType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of data repository task to create.
         * </p>
         * 
         * @param type
         *        Specifies the type of data repository task to create.
         * @see DataRepositoryTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataRepositoryTaskType
         */
        Builder type(DataRepositoryTaskType type);

        /**
         * <p>
         * (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed.
         * The default path is the file system root directory.
         * </p>
         * 
         * @param paths
         *        (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is
         *        processed. The default path is the file system root directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(Collection<String> paths);

        /**
         * <p>
         * (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is processed.
         * The default path is the file system root directory.
         * </p>
         * 
         * @param paths
         *        (Optional) The path or paths on the Amazon FSx file system to use when the data repository task is
         *        processed. The default path is the file system root directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paths(String... paths);

        /**
         * Sets the value of the FileSystemId property for this object.
         *
         * @param fileSystemId
         *        The new value for the FileSystemId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport
         * provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the
         * <code>Scope</code> parameter.
         * </p>
         * 
         * @param report
         *        Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A
         *        CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the
         *        criteria specified by the <code>Scope</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder report(CompletionReport report);

        /**
         * <p>
         * Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport
         * provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the
         * <code>Scope</code> parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link CompletionReport.Builder} avoiding the need to
         * create one manually via {@link CompletionReport#builder()}.
         *
         * When the {@link Consumer} completes, {@link CompletionReport.Builder#build()} is called immediately and its
         * result is passed to {@link #report(CompletionReport)}.
         * 
         * @param report
         *        a consumer that will call methods on {@link CompletionReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #report(CompletionReport)
         */
        default Builder report(Consumer<CompletionReport.Builder> report) {
            return report(CompletionReport.builder().applyMutation(report).build());
        }

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String type;

        private List<String> paths = DefaultSdkAutoConstructList.getInstance();

        private String fileSystemId;

        private CompletionReport report;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataRepositoryTaskRequest model) {
            super(model);
            type(model.type);
            paths(model.paths);
            fileSystemId(model.fileSystemId);
            report(model.report);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataRepositoryTaskType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<String> getPaths() {
            return paths;
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = DataRepositoryTaskPathsCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String... paths) {
            paths(Arrays.asList(paths));
            return this;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = DataRepositoryTaskPathsCopier.copy(paths);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final CompletionReport.Builder getReport() {
            return report != null ? report.toBuilder() : null;
        }

        @Override
        public final Builder report(CompletionReport report) {
            this.report = report;
            return this;
        }

        public final void setReport(CompletionReport.BuilderImpl report) {
            this.report = report != null ? report.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataRepositoryTaskRequest build() {
            return new CreateDataRepositoryTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
