/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for the <code>CreateFileSystemFromBackup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemFromBackupRequest extends FSxRequest implements
        ToCopyableBuilder<CreateFileSystemFromBackupRequest.Builder, CreateFileSystemFromBackupRequest> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemFromBackupRequest::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemFromBackupRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateFileSystemFromBackupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateFileSystemFromBackupRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateFileSystemFromBackupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CreateFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField
            .<CreateFileSystemWindowsConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFileSystemFromBackupRequest::windowsConfiguration))
            .setter(setter(Builder::windowsConfiguration)).constructor(CreateFileSystemWindowsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, WINDOWS_CONFIGURATION_FIELD));

    private final String backupId;

    private final String clientRequestToken;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final List<Tag> tags;

    private final CreateFileSystemWindowsConfiguration windowsConfiguration;

    private CreateFileSystemFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.clientRequestToken = builder.clientRequestToken;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.windowsConfiguration = builder.windowsConfiguration;
    }

    /**
     * Returns the value of the BackupId property for this object.
     * 
     * @return The value of the BackupId property for this object.
     */
    public String backupId() {
        return backupId;
    }

    /**
     * <p>
     * (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string
     * is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
     * </p>
     * 
     * @return (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This
     *         string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an
     *         AWS SDK.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs for the subnets that the file system will be accessible from. Currently, you can specify only one
     * subnet. The file server is also launched in that subnet's Availability Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of IDs for the subnets that the file system will be accessible from. Currently, you can specify
     *         only one subnet. The file server is also launched in that subnet's Availability Zone.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system
     * access. These security groups apply to all network interfaces. This value isn't returned in later describe
     * requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of IDs for the security groups that apply to the specified network interfaces created for file
     *         system access. These security groups apply to all network interfaces. This value isn't returned in later
     *         describe requests.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
     * appears in the console as the file system name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be applied to the file system at file system creation. The key value of the <code>Name</code>
     *         tag appears in the console as the file system name.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for this Microsoft Windows file system.
     * </p>
     * 
     * @return The configuration for this Microsoft Windows file system.
     */
    public CreateFileSystemWindowsConfiguration windowsConfiguration() {
        return windowsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(windowsConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemFromBackupRequest)) {
            return false;
        }
        CreateFileSystemFromBackupRequest other = (CreateFileSystemFromBackupRequest) obj;
        return Objects.equals(backupId(), other.backupId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(tags(), other.tags()) && Objects.equals(windowsConfiguration(), other.windowsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFileSystemFromBackupRequest").add("BackupId", backupId())
                .add("ClientRequestToken", clientRequestToken()).add("SubnetIds", subnetIds())
                .add("SecurityGroupIds", securityGroupIds()).add("Tags", tags())
                .add("WindowsConfiguration", windowsConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WindowsConfiguration":
            return Optional.ofNullable(clazz.cast(windowsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemFromBackupRequest, T> g) {
        return obj -> g.apply((CreateFileSystemFromBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFileSystemFromBackupRequest> {
        /**
         * Sets the value of the BackupId property for this object.
         *
         * @param backupId
         *        The new value for the BackupId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This
         * string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
         * SDK.
         * </p>
         * 
         * @param clientRequestToken
         *        (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation.
         *        This string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS
         *        CLI) or an AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A list of IDs for the subnets that the file system will be accessible from. Currently, you can specify only
         * one subnet. The file server is also launched in that subnet's Availability Zone.
         * </p>
         * 
         * @param subnetIds
         *        A list of IDs for the subnets that the file system will be accessible from. Currently, you can specify
         *        only one subnet. The file server is also launched in that subnet's Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of IDs for the subnets that the file system will be accessible from. Currently, you can specify only
         * one subnet. The file server is also launched in that subnet's Availability Zone.
         * </p>
         * 
         * @param subnetIds
         *        A list of IDs for the subnets that the file system will be accessible from. Currently, you can specify
         *        only one subnet. The file server is also launched in that subnet's Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of IDs for the security groups that apply to the specified network interfaces created for file system
         * access. These security groups apply to all network interfaces. This value isn't returned in later describe
         * requests.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of IDs for the security groups that apply to the specified network interfaces created for file
         *        system access. These security groups apply to all network interfaces. This value isn't returned in
         *        later describe requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of IDs for the security groups that apply to the specified network interfaces created for file system
         * access. These security groups apply to all network interfaces. This value isn't returned in later describe
         * requests.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of IDs for the security groups that apply to the specified network interfaces created for file
         *        system access. These security groups apply to all network interfaces. This value isn't returned in
         *        later describe requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
         * appears in the console as the file system name.
         * </p>
         * 
         * @param tags
         *        The tags to be applied to the file system at file system creation. The key value of the
         *        <code>Name</code> tag appears in the console as the file system name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
         * appears in the console as the file system name.
         * </p>
         * 
         * @param tags
         *        The tags to be applied to the file system at file system creation. The key value of the
         *        <code>Name</code> tag appears in the console as the file system name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
         * appears in the console as the file system name.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The configuration for this Microsoft Windows file system.
         * </p>
         * 
         * @param windowsConfiguration
         *        The configuration for this Microsoft Windows file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsConfiguration(CreateFileSystemWindowsConfiguration windowsConfiguration);

        /**
         * <p>
         * The configuration for this Microsoft Windows file system.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateFileSystemWindowsConfiguration.Builder}
         * avoiding the need to create one manually via {@link CreateFileSystemWindowsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateFileSystemWindowsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #windowsConfiguration(CreateFileSystemWindowsConfiguration)}.
         * 
         * @param windowsConfiguration
         *        a consumer that will call methods on {@link CreateFileSystemWindowsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowsConfiguration(CreateFileSystemWindowsConfiguration)
         */
        default Builder windowsConfiguration(Consumer<CreateFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return windowsConfiguration(CreateFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String backupId;

        private String clientRequestToken;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private CreateFileSystemWindowsConfiguration windowsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemFromBackupRequest model) {
            super(model);
            backupId(model.backupId);
            clientRequestToken(model.clientRequestToken);
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            windowsConfiguration(model.windowsConfiguration);
        }

        public final String getBackupId() {
            return backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final CreateFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return windowsConfiguration != null ? windowsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder windowsConfiguration(CreateFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final void setWindowsConfiguration(CreateFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileSystemFromBackupRequest build() {
            return new CreateFileSystemFromBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
