/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object for the <code>DeleteFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileSystemResponse extends FSxResponse implements
        ToCopyableBuilder<DeleteFileSystemResponse.Builder, DeleteFileSystemResponse> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteFileSystemResponse::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteFileSystemResponse::lifecycleAsString)).setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<DeleteFileSystemWindowsResponse> WINDOWS_RESPONSE_FIELD = SdkField
            .<DeleteFileSystemWindowsResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteFileSystemResponse::windowsResponse)).setter(setter(Builder::windowsResponse))
            .constructor(DeleteFileSystemWindowsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            LIFECYCLE_FIELD, WINDOWS_RESPONSE_FIELD));

    private final String fileSystemId;

    private final String lifecycle;

    private final DeleteFileSystemWindowsResponse windowsResponse;

    private DeleteFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.lifecycle = builder.lifecycle;
        this.windowsResponse = builder.windowsResponse;
    }

    /**
     * <p>
     * The ID of the file system being deleted.
     * </p>
     * 
     * @return The ID of the file system being deleted.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link FileSystemLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
     * @see FileSystemLifecycle
     */
    public FileSystemLifecycle lifecycle() {
        return FileSystemLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link FileSystemLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
     * @see FileSystemLifecycle
     */
    public String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * Returns the value of the WindowsResponse property for this object.
     * 
     * @return The value of the WindowsResponse property for this object.
     */
    public DeleteFileSystemWindowsResponse windowsResponse() {
        return windowsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(windowsResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemResponse)) {
            return false;
        }
        DeleteFileSystemResponse other = (DeleteFileSystemResponse) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(windowsResponse(), other.windowsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteFileSystemResponse").add("FileSystemId", fileSystemId())
                .add("Lifecycle", lifecycleAsString()).add("WindowsResponse", windowsResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "WindowsResponse":
            return Optional.ofNullable(clazz.cast(windowsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemResponse, T> g) {
        return obj -> g.apply((DeleteFileSystemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFileSystemResponse> {
        /**
         * <p>
         * The ID of the file system being deleted.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
         * </p>
         * 
         * @param lifecycle
         *        The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
         * @see FileSystemLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
         * </p>
         * 
         * @param lifecycle
         *        The file system lifecycle for the deletion request. Should be <code>DELETING</code>.
         * @see FileSystemLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemLifecycle
         */
        Builder lifecycle(FileSystemLifecycle lifecycle);

        /**
         * Sets the value of the WindowsResponse property for this object.
         *
         * @param windowsResponse
         *        The new value for the WindowsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsResponse(DeleteFileSystemWindowsResponse windowsResponse);

        /**
         * Sets the value of the WindowsResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link DeleteFileSystemWindowsResponse.Builder}
         * avoiding the need to create one manually via {@link DeleteFileSystemWindowsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteFileSystemWindowsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #windowsResponse(DeleteFileSystemWindowsResponse)}.
         * 
         * @param windowsResponse
         *        a consumer that will call methods on {@link DeleteFileSystemWindowsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowsResponse(DeleteFileSystemWindowsResponse)
         */
        default Builder windowsResponse(Consumer<DeleteFileSystemWindowsResponse.Builder> windowsResponse) {
            return windowsResponse(DeleteFileSystemWindowsResponse.builder().applyMutation(windowsResponse).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String fileSystemId;

        private String lifecycle;

        private DeleteFileSystemWindowsResponse windowsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemResponse model) {
            super(model);
            fileSystemId(model.fileSystemId);
            lifecycle(model.lifecycle);
            windowsResponse(model.windowsResponse);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getLifecycleAsString() {
            return lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(FileSystemLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        public final DeleteFileSystemWindowsResponse.Builder getWindowsResponse() {
            return windowsResponse != null ? windowsResponse.toBuilder() : null;
        }

        @Override
        public final Builder windowsResponse(DeleteFileSystemWindowsResponse windowsResponse) {
            this.windowsResponse = windowsResponse;
            return this;
        }

        public final void setWindowsResponse(DeleteFileSystemWindowsResponse.BuilderImpl windowsResponse) {
            this.windowsResponse = windowsResponse != null ? windowsResponse.build() : null;
        }

        @Override
        public DeleteFileSystemResponse build() {
            return new DeleteFileSystemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
