/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for the <code>UpdateFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemRequest extends FSxRequest implements
        ToCopyableBuilder<UpdateFileSystemRequest.Builder, UpdateFileSystemRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemRequest::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<UpdateFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField
            .<UpdateFileSystemWindowsConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateFileSystemRequest::windowsConfiguration)).setter(setter(Builder::windowsConfiguration))
            .constructor(UpdateFileSystemWindowsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build())
            .build();

    private static final SdkField<UpdateFileSystemLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField
            .<UpdateFileSystemLustreConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateFileSystemRequest::lustreConfiguration)).setter(setter(Builder::lustreConfiguration))
            .constructor(UpdateFileSystemLustreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, WINDOWS_CONFIGURATION_FIELD, LUSTRE_CONFIGURATION_FIELD));

    private final String fileSystemId;

    private final String clientRequestToken;

    private final UpdateFileSystemWindowsConfiguration windowsConfiguration;

    private final UpdateFileSystemLustreConfiguration lustreConfiguration;

    private UpdateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.clientRequestToken = builder.clientRequestToken;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
    }

    /**
     * Returns the value of the FileSystemId property for this object.
     * 
     * @return The value of the FileSystemId property for this object.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string
     * is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
     * </p>
     * 
     * @return (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This
     *         string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an
     *         AWS SDK.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The configuration update for this Microsoft Windows file system. The only supported options are for backup and
     * maintenance and for self-managed Active Directory configuration.
     * </p>
     * 
     * @return The configuration update for this Microsoft Windows file system. The only supported options are for
     *         backup and maintenance and for self-managed Active Directory configuration.
     */
    public UpdateFileSystemWindowsConfiguration windowsConfiguration() {
        return windowsConfiguration;
    }

    /**
     * Returns the value of the LustreConfiguration property for this object.
     * 
     * @return The value of the LustreConfiguration property for this object.
     */
    public UpdateFileSystemLustreConfiguration lustreConfiguration() {
        return lustreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lustreConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemRequest)) {
            return false;
        }
        UpdateFileSystemRequest other = (UpdateFileSystemRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(windowsConfiguration(), other.windowsConfiguration())
                && Objects.equals(lustreConfiguration(), other.lustreConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFileSystemRequest").add("FileSystemId", fileSystemId())
                .add("ClientRequestToken", clientRequestToken()).add("WindowsConfiguration", windowsConfiguration())
                .add("LustreConfiguration", lustreConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "WindowsConfiguration":
            return Optional.ofNullable(clazz.cast(windowsConfiguration()));
        case "LustreConfiguration":
            return Optional.ofNullable(clazz.cast(lustreConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemRequest, T> g) {
        return obj -> g.apply((UpdateFileSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFileSystemRequest> {
        /**
         * Sets the value of the FileSystemId property for this object.
         *
         * @param fileSystemId
         *        The new value for the FileSystemId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This
         * string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
         * SDK.
         * </p>
         * 
         * @param clientRequestToken
         *        (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates.
         *        This string is automatically filled on your behalf when you use the AWS Command Line Interface (AWS
         *        CLI) or an AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The configuration update for this Microsoft Windows file system. The only supported options are for backup
         * and maintenance and for self-managed Active Directory configuration.
         * </p>
         * 
         * @param windowsConfiguration
         *        The configuration update for this Microsoft Windows file system. The only supported options are for
         *        backup and maintenance and for self-managed Active Directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsConfiguration(UpdateFileSystemWindowsConfiguration windowsConfiguration);

        /**
         * <p>
         * The configuration update for this Microsoft Windows file system. The only supported options are for backup
         * and maintenance and for self-managed Active Directory configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateFileSystemWindowsConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateFileSystemWindowsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateFileSystemWindowsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #windowsConfiguration(UpdateFileSystemWindowsConfiguration)}.
         * 
         * @param windowsConfiguration
         *        a consumer that will call methods on {@link UpdateFileSystemWindowsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowsConfiguration(UpdateFileSystemWindowsConfiguration)
         */
        default Builder windowsConfiguration(Consumer<UpdateFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return windowsConfiguration(UpdateFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)
                    .build());
        }

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * @param lustreConfiguration
         *        The new value for the LustreConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lustreConfiguration(UpdateFileSystemLustreConfiguration lustreConfiguration);

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link UpdateFileSystemLustreConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateFileSystemLustreConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateFileSystemLustreConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lustreConfiguration(UpdateFileSystemLustreConfiguration)}.
         * 
         * @param lustreConfiguration
         *        a consumer that will call methods on {@link UpdateFileSystemLustreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lustreConfiguration(UpdateFileSystemLustreConfiguration)
         */
        default Builder lustreConfiguration(Consumer<UpdateFileSystemLustreConfiguration.Builder> lustreConfiguration) {
            return lustreConfiguration(UpdateFileSystemLustreConfiguration.builder().applyMutation(lustreConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private String clientRequestToken;

        private UpdateFileSystemWindowsConfiguration windowsConfiguration;

        private UpdateFileSystemLustreConfiguration lustreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            clientRequestToken(model.clientRequestToken);
            windowsConfiguration(model.windowsConfiguration);
            lustreConfiguration(model.lustreConfiguration);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final UpdateFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return windowsConfiguration != null ? windowsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder windowsConfiguration(UpdateFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final void setWindowsConfiguration(UpdateFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        public final UpdateFileSystemLustreConfiguration.Builder getLustreConfiguration() {
            return lustreConfiguration != null ? lustreConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lustreConfiguration(UpdateFileSystemLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final void setLustreConfiguration(UpdateFileSystemLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileSystemRequest build() {
            return new UpdateFileSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
