/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates the Microsoft Windows configuration for an existing Amazon FSx for Windows File Server file system. Amazon
 * FSx overwrites existing properties with non-null values provided in the request. If you don't specify a non-null
 * value for a property, that property is not updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemWindowsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateFileSystemWindowsConfiguration.Builder, UpdateFileSystemWindowsConfiguration> {
    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemWindowsConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemWindowsConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFileSystemWindowsConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<SelfManagedActiveDirectoryConfigurationUpdates> SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<SelfManagedActiveDirectoryConfigurationUpdates> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateFileSystemWindowsConfiguration::selfManagedActiveDirectoryConfiguration))
            .setter(setter(Builder::selfManagedActiveDirectoryConfiguration))
            .constructor(SelfManagedActiveDirectoryConfigurationUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SelfManagedActiveDirectoryConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WEEKLY_MAINTENANCE_START_TIME_FIELD, DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD,
            SELF_MANAGED_ACTIVE_DIRECTORY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String weeklyMaintenanceStartTime;

    private final String dailyAutomaticBackupStartTime;

    private final Integer automaticBackupRetentionDays;

    private final SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;

    private UpdateFileSystemWindowsConfiguration(BuilderImpl builder) {
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
    }

    /**
     * <p>
     * The preferred time to perform weekly maintenance, in the UTC time zone.
     * </p>
     * 
     * @return The preferred time to perform weekly maintenance, in the UTC time zone.
     */
    public String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * <p>
     * The preferred time to take daily automatic backups, in the UTC time zone.
     * </p>
     * 
     * @return The preferred time to take daily automatic backups, in the UTC time zone.
     */
    public String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain
     * automatic backups for a maximum of 35 days.
     * </p>
     * 
     * @return The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can
     *         retain automatic backups for a maximum of 35 days.
     */
    public Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD
     * directory.
     * </p>
     * 
     * @return The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft
     *         AD directory.
     */
    public SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration() {
        return selfManagedActiveDirectoryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedActiveDirectoryConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemWindowsConfiguration)) {
            return false;
        }
        UpdateFileSystemWindowsConfiguration other = (UpdateFileSystemWindowsConfiguration) obj;
        return Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(selfManagedActiveDirectoryConfiguration(), other.selfManagedActiveDirectoryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFileSystemWindowsConfiguration")
                .add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("SelfManagedActiveDirectoryConfiguration", selfManagedActiveDirectoryConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "SelfManagedActiveDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(selfManagedActiveDirectoryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemWindowsConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemWindowsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateFileSystemWindowsConfiguration> {
        /**
         * <p>
         * The preferred time to perform weekly maintenance, in the UTC time zone.
         * </p>
         * 
         * @param weeklyMaintenanceStartTime
         *        The preferred time to perform weekly maintenance, in the UTC time zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * <p>
         * The preferred time to take daily automatic backups, in the UTC time zone.
         * </p>
         * 
         * @param dailyAutomaticBackupStartTime
         *        The preferred time to take daily automatic backups, in the UTC time zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain
         * automatic backups for a maximum of 35 days.
         * </p>
         * 
         * @param automaticBackupRetentionDays
         *        The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can
         *        retain automatic backups for a maximum of 35 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD
         * directory.
         * </p>
         * 
         * @param selfManagedActiveDirectoryConfiguration
         *        The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed
         *        Microsoft AD directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration);

        /**
         * <p>
         * The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD
         * directory.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder} avoiding the need to create one manually via
         * {@link SelfManagedActiveDirectoryConfigurationUpdates#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates)}.
         * 
         * @param selfManagedActiveDirectoryConfiguration
         *        a consumer that will call methods on {@link SelfManagedActiveDirectoryConfigurationUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates)
         */
        default Builder selfManagedActiveDirectoryConfiguration(
                Consumer<SelfManagedActiveDirectoryConfigurationUpdates.Builder> selfManagedActiveDirectoryConfiguration) {
            return selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationUpdates.builder()
                    .applyMutation(selfManagedActiveDirectoryConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String weeklyMaintenanceStartTime;

        private String dailyAutomaticBackupStartTime;

        private Integer automaticBackupRetentionDays;

        private SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemWindowsConfiguration model) {
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            selfManagedActiveDirectoryConfiguration(model.selfManagedActiveDirectoryConfiguration);
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        public final SelfManagedActiveDirectoryConfigurationUpdates.Builder getSelfManagedActiveDirectoryConfiguration() {
            return selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder selfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
            return this;
        }

        public final void setSelfManagedActiveDirectoryConfiguration(
                SelfManagedActiveDirectoryConfigurationUpdates.BuilderImpl selfManagedActiveDirectoryConfiguration) {
            this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration != null ? selfManagedActiveDirectoryConfiguration
                    .build() : null;
        }

        @Override
        public UpdateFileSystemWindowsConfiguration build() {
            return new UpdateFileSystemWindowsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
