/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.ContainerFleet;
import software.amazon.awssdk.services.gamelift.model.ListContainerFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerFleetsResponse;

public class ListContainerFleetsPublisher
implements SdkPublisher<ListContainerFleetsResponse> {
    private final GameLiftAsyncClient client;
    private final ListContainerFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContainerFleetsPublisher(GameLiftAsyncClient client, ListContainerFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContainerFleetsPublisher(GameLiftAsyncClient client, ListContainerFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContainerFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContainerFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContainerFleet> containerFleets() {
        Function<ListContainerFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerFleets() != null) {
                return response.containerFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContainerFleetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContainerFleetsResponseFetcher
    implements AsyncPageFetcher<ListContainerFleetsResponse> {
        private ListContainerFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContainerFleetsResponse> nextPage(ListContainerFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListContainerFleetsPublisher.this.client.listContainerFleets(ListContainerFleetsPublisher.this.firstRequest);
            }
            return ListContainerFleetsPublisher.this.client.listContainerFleets((ListContainerFleetsRequest)((Object)ListContainerFleetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

