/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecordTypeCode {
    FIRM("Firm"),
    GENERAL("General"),
    HIGH_RISE("HighRise"),
    POST_OFFICE_BOX("PostOfficeBox"),
    RURAL("Rural"),
    STREET("Street"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecordTypeCode> VALUE_MAP;
    private final String value;

    private RecordTypeCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordTypeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordTypeCode> knownValues() {
        EnumSet<RecordTypeCode> knownValues = EnumSet.allOf(RecordTypeCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecordTypeCode.class, RecordTypeCode::toString);
    }
}

