/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConnectionPropertyKey {
    HOST("HOST"),
    PORT("PORT"),
    USERNAME("USERNAME"),
    PASSWORD("PASSWORD"),
    ENCRYPTED_PASSWORD("ENCRYPTED_PASSWORD"),
    JDBC_DRIVER_JAR_URI("JDBC_DRIVER_JAR_URI"),
    JDBC_DRIVER_CLASS_NAME("JDBC_DRIVER_CLASS_NAME"),
    JDBC_ENGINE("JDBC_ENGINE"),
    JDBC_ENGINE_VERSION("JDBC_ENGINE_VERSION"),
    CONFIG_FILES("CONFIG_FILES"),
    INSTANCE_ID("INSTANCE_ID"),
    JDBC_CONNECTION_URL("JDBC_CONNECTION_URL"),
    JDBC_ENFORCE_SSL("JDBC_ENFORCE_SSL"),
    CUSTOM_JDBC_CERT("CUSTOM_JDBC_CERT"),
    SKIP_CUSTOM_JDBC_CERT_VALIDATION("SKIP_CUSTOM_JDBC_CERT_VALIDATION"),
    CUSTOM_JDBC_CERT_STRING("CUSTOM_JDBC_CERT_STRING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConnectionPropertyKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionPropertyKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConnectionPropertyKey.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionPropertyKey> knownValues() {
        return Stream.of(ConnectionPropertyKey.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

