/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PropertyPredicate;
import software.amazon.awssdk.services.glue.model.SearchPropertyPredicatesCopier;
import software.amazon.awssdk.services.glue.model.SortCriteriaCopier;
import software.amazon.awssdk.services.glue.model.SortCriterion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTablesRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, SearchTablesRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchTablesRequest.getter(SearchTablesRequest::catalogId)).setter(SearchTablesRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchTablesRequest.getter(SearchTablesRequest::nextToken)).setter(SearchTablesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PropertyPredicate>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchTablesRequest.getter(SearchTablesRequest::filters)).setter(SearchTablesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyPredicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchTablesRequest.getter(SearchTablesRequest::searchText)).setter(SearchTablesRequest.setter(Builder::searchText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchText").build()}).build();
    private static final SdkField<List<SortCriterion>> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchTablesRequest.getter(SearchTablesRequest::sortCriteria)).setter(SearchTablesRequest.setter(Builder::sortCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SortCriterion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SearchTablesRequest.getter(SearchTablesRequest::maxResults)).setter(SearchTablesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, SEARCH_TEXT_FIELD, SORT_CRITERIA_FIELD, MAX_RESULTS_FIELD));
    private final String catalogId;
    private final String nextToken;
    private final List<PropertyPredicate> filters;
    private final String searchText;
    private final List<SortCriterion> sortCriteria;
    private final Integer maxResults;

    private SearchTablesRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.searchText = builder.searchText;
        this.sortCriteria = builder.sortCriteria;
        this.maxResults = builder.maxResults;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<PropertyPredicate> filters() {
        return this.filters;
    }

    public String searchText() {
        return this.searchText;
    }

    public boolean hasSortCriteria() {
        return this.sortCriteria != null && !(this.sortCriteria instanceof SdkAutoConstructList);
    }

    public List<SortCriterion> sortCriteria() {
        return this.sortCriteria;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchText());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTablesRequest)) {
            return false;
        }
        SearchTablesRequest other = (SearchTablesRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.searchText(), other.searchText()) && Objects.equals(this.sortCriteria(), other.sortCriteria()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"SearchTablesRequest").add("CatalogId", (Object)this.catalogId()).add("NextToken", (Object)this.nextToken()).add("Filters", this.filters()).add("SearchText", (Object)this.searchText()).add("SortCriteria", this.sortCriteria()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "SearchText": {
                return Optional.ofNullable(clazz.cast(this.searchText()));
            }
            case "SortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTablesRequest, T> g) {
        return obj -> g.apply((SearchTablesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String nextToken;
        private List<PropertyPredicate> filters = DefaultSdkAutoConstructList.getInstance();
        private String searchText;
        private List<SortCriterion> sortCriteria = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTablesRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.nextToken(model.nextToken);
            this.filters(model.filters);
            this.searchText(model.searchText);
            this.sortCriteria(model.sortCriteria);
            this.maxResults(model.maxResults);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PropertyPredicate.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(PropertyPredicate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<PropertyPredicate> filters) {
            this.filters = SearchPropertyPredicatesCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(PropertyPredicate ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<PropertyPredicate.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (PropertyPredicate)((PropertyPredicate.Builder)PropertyPredicate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<PropertyPredicate.BuilderImpl> filters) {
            this.filters = SearchPropertyPredicatesCopier.copyFromBuilder(filters);
        }

        public final String getSearchText() {
            return this.searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        public final Collection<SortCriterion.Builder> getSortCriteria() {
            return this.sortCriteria != null ? (Collection)this.sortCriteria.stream().map(SortCriterion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sortCriteria(Collection<SortCriterion> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(SortCriterion ... sortCriteria) {
            this.sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Consumer<SortCriterion.Builder> ... sortCriteria) {
            this.sortCriteria(Stream.of(sortCriteria).map(c -> (SortCriterion)((SortCriterion.Builder)SortCriterion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSortCriteria(Collection<SortCriterion.BuilderImpl> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copyFromBuilder(sortCriteria);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchTablesRequest build() {
            return new SearchTablesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTablesRequest> {
        public Builder catalogId(String var1);

        public Builder nextToken(String var1);

        public Builder filters(Collection<PropertyPredicate> var1);

        public Builder filters(PropertyPredicate ... var1);

        public Builder filters(Consumer<PropertyPredicate.Builder> ... var1);

        public Builder searchText(String var1);

        public Builder sortCriteria(Collection<SortCriterion> var1);

        public Builder sortCriteria(SortCriterion ... var1);

        public Builder sortCriteria(Consumer<SortCriterion.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

